@props([ 'permission' => null])

@php
$isEdit = isset($permission) && $permission->exists;
@endphp

<form action="{{ $isEdit ? route('admin.settings.permission.update' , $permission->id ) : route('admin.settings.permission.store') }}" method="POST">
    @csrf

    @if($isEdit)
    @method('PATCH')
    @endif

    <div class="mb-3">
        <label for="name" class="form-label">{{ __('Permission Name') }}</label>
        <input type="text" name="name" class="form-control" value="{{ old('name', $permission->name ?? '') }}" required>
    </div>



    <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
</form>
