@props(['preInvoice' , 'quote' => null])


@php
$isEdit = $quote !== null ? true : false;

$action = $isEdit ? route('admin.pre-invoice.quote.update' , ['pre_invoice' => $preInvoice->id , 'quote' =>$quote->id]) : route('admin.pre-invoice.quote.store' , $preInvoice->id);

@endphp

<form action="{{ $action }}" method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
    @csrf

    @if($isEdit)
    @method('PUT')
    @endif

    <input type="text" name="pre_invoice_id" value="{{ $preInvoice->id }}" hidden>

    <div class="mb-3">
        <label for="supplier_id">
            {{ __('seller') }}
        </label>
        @if (auth()->user()->isAdmin())
        <select class="form-select" name="supplier_id" id="supplier_id">
            @foreach (\App\Models\Shop::approved()->get() as $seller )
            <option value="{{ $seller->id }}">
                {{ $seller->name }}
            </option>
            @endforeach
        </select>
        @else
        <input class="form-control" type="text" value="{{ auth()->user()->shop->name }}" disabled>
        <input type="text" value="{{ auth()->user()->shop->id }}" name="supplier_id" hidden>
        @endif
    </div>

    <div>
        @foreach ($preInvoice->items as $item )
        <div class="row border border-3 rounded p-3 m-3">
            <div class="col-12">
                <p class="fw-bold h6">
                    <span>
                        {{ $loop->iteration }}# -
                    </span>

                    <span>{{ $item->name }}</span>
                </p>
            </div>
            <div class="col">
                <label for="">{{ __('price') }}</label>
                <input class="form-control " name="items[{{ $item->id }}][price]" value="{{ old("items.$item->id.price" , ($quote !== null ? $quote->items->keyBy('id')->get($item->id)->price : '')) }}" type="text">
            </div>
            <div class="col">
                <label for="">{{ __('count') }}</label>
                <input class="form-control " name="items[{{ $item->id }}][qty]" value="{{ old("items.$item->id.qty" , ($quote !== null ? $quote->items->keyBy('id')->get($item->id)->qty : '')) }}" type="text">
            </div>
            <div class="col">
                <label for="">{{ __('delivery time (day)') }}</label>
                <input class="form-control " name="items[{{ $item->id }}][delivery_time]" value="{{ old("items.$item->id.delivery_time" , ($quote !== null ? $quote->items->keyBy('id')->get($item->id)->delivery_time : '')) }}" type="text">
            </div>
            <div class="col-12 ">
                <label for="">{{ __('note') }}</label>
                <textarea class="form-control " name="items[{{ $item->id }}][note]" >{{ old("items.$item->id.note" , ($quote !== null ? $quote->items->keyBy('id')->get($item->id)->note : '')) }}</textarea>
            </div>
        </div>
        @endforeach
    </div>


    <div class="d-flex justify-content-end">
        <button type="submit" class="btn btn-primary px-5">
            {{ __('submit') }}
        </button>
    </div>
</form>

