<form method="GET" class="p-3 border rounded bg-light">
    <div class="row g-3">
        <div class="col-md-4">
            <label class="form-label">عنوان یا کد:</label>
            <input type="text" name="q" value="{{ request('q') }}" class="form-control" placeholder="جستجو...">
        </div>
        <div class="col-md-4">
            <label class="form-label">وضعیت:</label>
            <select name="status" class="form-select">
                <option value="">همه</option>
                @foreach(\App\Enums\ProductStatusEnum::cases() as $status)
                <option value="{{ $status->value }}" @selected(request('status')==$status->value)>
                    {{ __($status->name) }}
                </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">حداقل قیمت:</label>
            <input type="number" name="price_min" value="{{ request('price_min') }}" class="form-control" placeholder="حداقل">
        </div>
        <div class="col-md-4">
            <label class="form-label">حداکثر قیمت:</label>
            <input type="number" name="price_max" value="{{ request('price_max') }}" class="form-control" placeholder="حداکثر">
        </div>


        <div class="col-md-4">
            <label class="form-label">دسته‌بندی:</label>
            <select name="category" class="form-select">
                <option value="">همه</option>
                @foreach(\App\Models\Category::all() as $cat)
                <option value="{{ $cat->id }}" @selected(request('category')==$cat->id)>
                    {{ $cat->name }}
                </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">برچسب:</label>
            <select name="tag" class="form-select">
                <option value="">همه</option>
                @foreach(\App\Models\Tag::all() as $tag)
                <option value="{{ $tag->id }}" @selected(request('tag')==$tag->id)>
                    {{ $tag->name }}
                </option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">دست دوم:</label>
            <select name="second_hand" class="form-select">
                <option value="">همه</option>
                <option value="1" @selected(request('second_hand')=='1' )>بله</option>
                <option value="0" @selected(request('second_hand')=='0' )>خیر</option>
            </select>
        </div>


        <div class="col-md-4">
            <x-form.persian-datepicker
                name="created_at"
                label="تاریخ ایجاد"
                value="{{ request('created_at') }}"
                timePicker="false" />

        </div>
        <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary mt-2">فیلتر</button>
            <a href="{{ request()->url() }}" class="btn btn-secondary mt-2">حذف فیلتر</a>
        </div>
    </div>
</form>
