@props(['product' => null])

<div>
    <div class="border border-3 p-4 rounded mb-3">
        <div class="row g-3">
            <!-- product status -->
            <div id="product-status-container" class="col-12">
                <label for="status" class="form-label">{{ __('Status') }} <span class="text-danger">*</span> </label>
                <select class="form-select" name="status" id="status">
                    @hasrole('Shop')
                    <option value="{{ App\Enums\ProductStatusEnum::Review->value }}" selected> {{ __(App\Enums\ProductStatusEnum::Review->value) }} </option>
                    @endhasrole
                    @hasanyrole('Administrator|Admin')
                    @foreach (App\Enums\ProductStatusEnum::values() as $status)
                    <option value="{{ $status }}"> {{ __($status) }} </option>
                    @endforeach
                    @endhasanyrole()

                </select>
            </div>

            <!-- product slug -->
            <div id="product-slug-container" class="mb-3 col-12">
                <label class="form-label"> {{ __('slug') }} <span class="text-danger">*</span> </label>
                <input type="text" name="slug" class="form-control" dir="ltr" value="{{ old('slug' ,$product?->slug) }}">
                <small class="d-block text-align-justify">
                    {{ __('In this section, enter the text that should be displayed in the address bar in English, if left blank, the product title will be placed as a default.') }}
                </small>
            </div>

            <!-- product short description -->
            <div id="product-short-desc-container" class="mb-3 col-12">
                <label class="form-label"> {{ __('summery') }} </label>
                <textarea class="form-control w-100" name="short_description" id="" rows="5">{{old('short_description' ,$product?->short_description)}}</textarea>
            </div>
        </div>
    </div>

    <div class="border border-3 p-4 rounded mb-3">
        <div class="row g-3">

            <div class="row row-cols-1 row-cols-md-3 row-cols-lg-3 g-3">
                <div id="product-length-container" class="mb-3 ">
                    <label class="form-label"> {{ __('Length') }} </label>
                    <input type="text" name="length" class="form-control" dir="ltr" value="{{ old('length',$product?->length) }}">
                </div>
                <div id="product-width-container" class="mb-3 ">
                    <label class="form-label"> {{ __('Width') }} </label>
                    <input type="text" name="width" class="form-control" dir="ltr" value="{{ old('width',$product?->width) }}">
                </div>
                <div id="product-height-container" class="mb-3 ">
                    <label class="form-label"> {{ __('Height') }} </label>
                    <input type="text" name="height" class="form-control" dir="ltr" value="{{ old('height',$product?->height) }}">
                </div>
            </div>

            <!-- is this product a second hand product? -->
            <div id="product-second-hand-container" class="form-check mb-3 col-12">
                <input class="form-check-input" type="checkbox" value="true" name="consumable" id="consumable" <?php echo (old('consumable', $product?->consumable) == true) ? 'checked' : '' ?>>
                <label class="form-check-label" for="consumable">
                    {{ __('consumable product') }}
                </label>
            </div>
            <!-- is this product a second hand product? -->
            <div id="product-second-hand-container" class="form-check mb-3 col-12">
                <input class="form-check-input" type="checkbox" value="true" name="second_hand" id="second_hand" <?php echo (old('second_hand', $product?->second_hand) == true) ? 'checked' : '' ?>>
                <label class="form-check-label" for="second_hand">
                    {{ __('second hand product') }}
                </label>
            </div>


            <!-- input for product price   -->
            <div id="product-price-container" class="mb-3 col-12">
                <label class="form-label"> {{ __('price') }} </label>
                <input type="text" name="price" class="form-control" dir="ltr" value="{{ old('price',$product?->price) }}">
            </div>

            <!-- input for product price discount   -->
            <div id="product-price-with-discount-container" class="mb-3 col-12">
                <label class="form-label"> {{ __('price with discount') }} </label>
                <input type="text" name="discount_price" class="form-control" dir="ltr" value="{{ old('discount_price',$product?->discount_price) }}">
            </div>

            <!-- input for product off rate   -->
            <div id="product-off-rate-container" class="mb-3 col-12">
                <label class="form-label"> {{ __('OFF rate') }} </label>
                <input type="text" name="off_rate" class="form-control" dir="ltr" value="{{ old('off_rate',$product?->off_rate) }}">
            </div>

            <!-- weight for product -->
            <div id="product-weight-price-container" class="mb-3 col-12">
                <label class="form-label"> {{ __('weight') }} (g) </label>
                <input type="text" name="weight" class="form-control" dir="ltr" value="{{ old('weight' ,$product?->weight) }}">
            </div>

            <!-- product inventory -->
            <div id="product-inventory-container" class="mb-3 col-12">
                <label class="form-label"> {{ __('inventory') }} </label>
                <input type="text" name="inventory" class="form-control" dir="ltr" value="{{ old('inventory',$product?->inventory) }}">
            </div>
            <!-- product tag -->
            <div class="mb-4">
                <label for="multiple-select-field" class="form-label">{{ __('tags') }}</label>
                <select name="tag[]" class="form-select" id="multiple-select-field" data-placeholder="Choose anything" multiple>
                    @foreach (\App\Models\Tag::all() as $tag)
                    <option value="{{ $tag->id }}" {{ in_array($tag->id, old('tags', $product?->tags->pluck('id')->toArray() ?? [])) ? 'selected' : '' }}> {{ $tag->name }} </option>
                    @endforeach
                </select>
            </div>
            <!-- product brand -->

            <div class="mb-4">
                <label for="single-select-field" class="form-label">{{ __('brands') }}</label>
                <select name="brand_id" class="form-select select2-hidden-accessible" id="single-select-field" data-placeholder="Choose anything">
                    <option value=""></option>
                    @foreach (\App\Models\Brand::inCategories(\App\Services\Models\CategoryService::getCategoriesParents($_GET['category_id'])->pluck('id')->toArray() ?? [])->get() as $brand)
                    <option value="{{ $brand->id }}" {{ $brand->id == old('brand_id', $product?->brand_id ?? null) ? 'selected' : '' }}> {{ $brand->name }} </option>
                    @endforeach
                </select>
            </div>

        </div>
    </div>
</div>
