@props([ 'role' => null, 'permissions' => []])

@php
$isEdit = isset($role) && $role->exists;
@endphp

<form action="{{ $isEdit ? route('admin.settings.role.update' , $role->id ) : route('admin.settings.role.store') }}" method="POST">
    @csrf

    @if($isEdit)
    @method('PATCH')
    @endif

    <div class="mb-3">
        <label for="name" class="form-label">{{ __('Role Name') }}</label>
        <input type="text" name="name" class="form-control" value="{{ old('name', $role->name ?? '') }}" required>
    </div>

    <div class="mb-3">
        <div class="d-flex justify-content-between">

            <label class="form-label">{{ __('Permissions') }}</label>
            <div class="form-check">
                <input id="select-all-permission" class="form-check-input" type="checkbox"
                    onclick="document.querySelectorAll('.form-check-input[name^=permissions]').forEach(checkbox => checkbox.checked = this.checked)">
                <label class="form-check-label cursor-pointer" for="select-all-permission">{{ __('Select All') }}</label>
            </div>
        </div>

        <div class="row">
            @foreach ($permissions as $group => $perms)
            <div class="m-0 col-sm-4">
                <div class="card">
                    <div class="card-body">
                        <p dir="ltr" class="fw-bold text-capitalize">
                            {{ str_replace('.', ' › ', $group) }}
                        </p>

                        <div class="d-flex gap-3">
                            @foreach ($perms as $permission)
                            <div class="">
                                <div class="form-check">
                                    <input id="permission-{{ $permission->id }}"
                                        class="form-check-input"
                                        type="checkbox"
                                        name="permissions[]"
                                        value="{{ $permission->name }}"
                                        {{ isset($role) && $role->hasPermissionTo($permission->name) ? 'checked' : '' }}>
                                    <label class="form-check-label cursor-pointer"
                                        for="permission-{{ $permission->id }}" title="{{ $permission->name }}">
                                        {{ __(Str::afterLast($permission->name, '.')) }}
                                    </label>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
</form>
