<!DOCTYPE html>
<html lang="fa-IR" dir="rtl">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    {!! seo()->meta() !!}

    @stack('meta')

    <title> {{ seo()->getTitle() }} </title>


    <link rel="icon" href="{{ getSiteLogo() }}" type="image/png" />

    <link rel="stylesheet" href="/assets/themes/blesser/css/base.css" />
    <link rel="stylesheet" href="/assets/themes/blesser/css/dependencies/swiper.min.css" />
    <link rel="stylesheet" href="/assets/themes/blesser/css/fonts.css" />
    <!-- <link rel="stylesheet" href="/assets/themes/blesser/css/app.css"/> -->
    <link rel="stylesheet" href="/assets/themes/blesser/css/dependencies/nouislider.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

    <style>
        [x-cloak] {
            display: none !important;
        }

        .loader {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            display: block;
            margin: 15px auto;
            position: relative;
            color: #FFF;
            box-sizing: border-box;
            animation: animloader 2s linear infinite;
        }

        @keyframes animloader {
            0% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 -2px, -14px 0 0 -2px, -38px 0 0 -2px;
            }

            25% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 -2px, -14px 0 0 -2px, -38px 0 0 2px;
            }

            50% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 -2px, -14px 0 0 2px, -38px 0 0 -2px;
            }

            75% {
                box-shadow: 14px 0 0 2px, 38px 0 0 -2px, -14px 0 0 -2px, -38px 0 0 -2px;
            }

            100% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 2px, -14px 0 0 -2px, -38px 0 0 -2px;
            }
        }
    </style>
    @yield('style')
    @stack('styles')

    <script src="/assets/themes/blesser/scripts/mount.js"></script>

    <script defer src="/assets/themes/blesser/scripts/dependencies/flowbite.min.js"></script>
    <script defer src="/assets/themes/blesser/scripts/dependencies/swiper.min.js"></script>
    <script defer src="/assets/themes/blesser/scripts/dependencies/nouislider.min.js"></script>

    <script defer src="/assets/themes/blesser/scripts/theme.js"></script>
    <script defer src="/assets/themes/blesser/scripts/header/indicator.js"></script>
    <script defer src="/assets/themes/blesser/scripts/scroll.js"></script>
    <script defer src="/assets/themes/blesser/scripts/header/search.js"></script>
    <script defer src="/assets/themes/blesser/scripts/header/magaMenu.js"></script>

    <script defer src="/assets/themes/blesser/scripts/app.js"></script>
    <script defer src="/assets/themes/blesser/scripts/swiper.js"></script>
    <script defer src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

    @livewireStyles

    @vite(['resources/css/app.css' , 'resources/js/app.js'])

</head>

<body>
    <div class="flex min-h-screen flex-col">
        @include('layouts.blesser.header')
        <!-- Mega menu Overlay -->
        <div id="desktop-mega-menu-overlay" class="fixed inset-0 z-20 hidden bg-black/40 backdrop-blur-md"></div>

        <main class="flex-grow bg-background pt-[146px]">
            @yield('content')
        </main>

        @include('layouts.blesser.footer')

        @include('layouts.blesser.mobile-bottom-menu')
    </div>
    <!-- Drawers -->
    @include('layouts.blesser.mobile-drawers')


    <!-- Modals -->
    @include('layouts.blesser.modal')
</body>

@livewireScriptConfig

@yield('script')
@stack('scripts')

</html>
