<!DOCTYPE html>
<html lang="en" dir="rtl" class="">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <!--favicon-->
    <link rel="icon" href="{{ getSiteLogo() }}" type="image/png" />
    <!--plugins-->
    <link href="/assets/themes/syndron/plugins/vectormap/jquery-jvectormap-2.0.2.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <!-- loader-->
    <link href="/assets/themes/syndron/css/pace.min.css" rel="stylesheet" />
    <script src="/assets/themes/syndron/js/pace.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="/assets/themes/syndron/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/css/bootstrap-extended.css" rel="stylesheet" />
    <!-- <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet" /> -->
    @if (auth()->user()->adminLayout() == 'vertical')
    <link href="/assets/themes/syndron/css/app.css" rel="stylesheet" />
    <link rel="stylesheet" href="/assets/themes/syndron/css/dark-theme.css" />

    @elseif (auth()->user()->adminLayout() == 'horizontal')
    <link href="/assets/themes/syndron/horizontal/css/app.css" rel="stylesheet" />
    <link rel="stylesheet" href="/assets/themes/syndron/horizontal/css/dark-theme.css" />

    @endif
    <link href="/assets/themes/syndron/css/icons.css" rel="stylesheet" />
    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="/assets/themes/syndron/css/semi-dark.css" />
    <link rel="stylesheet" href="/assets/themes/syndron/css/header-colors.css?v={{ env('APP_VERSION') }}" />
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@latest/dist/css/persian-datepicker.min.css" />

    <style>
        @font-face {
            font-family: 'IRANYekanXFaNum';
            src: url('/assets/themes/syndron/fonts/iranyekan/IRANYekanXFaNum-Light.woff2') format('woff2');
            font-weight: lighter;
            font-style: normal;
        }

        body {
            font-family: 'IRANYekanXFaNum', sans-serif;
        }

        [class^="apexcharts-"],
        [class*=" apexcharts-"] {
            font-family: 'IRANYekanXFaNum', sans-serif !important;
        }

        [x-cloak] {
            display: none !important;
        }

        .shortcut-button {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 6px 12px;
            gap: 8px;
            /* height: 34px; */
            /* width: 112px; */
            border: none;
            border-radius: 20px;
            cursor: pointer;
        }

        .shortcut-label {
            line-height: 15px;
            font-size: 12px;
            color: #000;
            letter-spacing: 1px;
        }

        .shortcut-button:hover {}

        html div.alert.alert-bg-white
        {
            background-color: white;
        }
        html.dark-theme div.alert.alert-bg-white
        {
            background-color: #161515;
        }
    </style>
    @livewireStyles

    @vite(['resources/css/admin/app.css' , 'resources/js/admin/app.js'])

    @yield('extra-vite')

    @yield('style')
    @stack('styles')

    <title> {{ getSiteName() }} | @yield('title') </title>

</head>

<body>
    <!--wrapper-->
    <div class="wrapper">


        @if (auth()->user()->adminLayout() == 'vertical')
        <!--sidebar wrapper -->
        @include('layouts.syndron.sidebar')
        <!--end sidebar wrapper -->

        <!--start header -->
        @include('layouts.syndron.header')
        <!--end header -->

        @elseif (auth()->user()->adminLayout() == 'horizontal')

        @include('layouts.syndron.horizontal')

        @endif




        <!--start page wrapper -->
        <div class="page-wrapper">
            <div class="page-content">
                @yield('content')
            </div>
        </div>
        <!--end page wrapper -->

        <!--start overlay-->
        <div class="overlay toggle-icon"></div>
        <!--end overlay-->

        <!--Start Back To Top Button-->
        <a href="javaScript:;" class="back-to-top"><i class="bx bxs-up-arrow-alt"></i></a>
        <!--End Back To Top Button-->

        @include('layouts.syndron.footer')
    </div>
    <!--end wrapper-->

    <!-- search modal -->
    <div class="modal" id="SearchModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl modal-fullscreen-md-down">
            <div class="modal-content">
                <livewire:admin.global-search />
            </div>
        </div>
    </div>
    <!-- end search modal -->

    <!--start switcher-->
    <div class="switcher-wrapper">

        <div class="switcher-body">
            <div class="d-flex align-items-center">
                <h5 class="mb-0 text-uppercase">{{ __('Theme Customizer')}}</h5>
                <button type="button" class="btn-close ms-auto close-switcher" aria-label="Close"></button>
            </div>
            <hr />
            <h6 class="fw-bold mb-0">{{ __('Theme Styles')}}</h6>
            <hr />
            <div class="d-flex align-items-center justify-content-between">
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="lightmode" checked />
                    <label class="form-check-label" for="lightmode">{{ __('Light')}}</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="darkmode" />
                    <label class="form-check-label" for="darkmode">{{ __('Dark')}}</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="semidark" />
                    <label class="form-check-label" for="semidark">{{ __('Semi Dark')}}</label>
                </div>
            </div>
            <hr />
            <div class="form-check">
                <input class="form-check-input" type="radio" id="minimaltheme" name="flexRadioDefault" />
                <label class="form-check-label" for="minimaltheme">{{ __('Minimal Theme')}}</label>
            </div>
            <hr />
            <h6 class="fw-bold mb-0">{{ __('Header Style')}}</h6>
            <hr />
            <form action="{{ route('admin.update.admin-layout') }}" method="post">
                @csrf
                <div class="d-flex align-items-center justify-content-between">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="admin_layout" id="Horizontal" value="horizontal" />
                        <label class="form-check-label" for="Horizontal">{{ __('Horizontal')}}</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="admin_layout" id="Vertical" value="vertical" />
                        <label class="form-check-label" for="Vertical">{{ __('Vertical')}}</label>
                    </div>
                </div>
                <div class="d-flex justify-content-end mt-3">
                    <button class="btn btn-sm btn-primary" type="submit" ">
                        {{ __('Save Changes')}}
                    </button>
                </div>
            </form>
            <hr />
            <h6 class="fw-bold mb-0">{{ __('Header Colors')}}</h6>
            <hr />
            <div class="header-colors-indigators">
                <div class="row row-cols-auto g-3">
                    <div class="col">
                        <div class="indigator headercolor1" id="headercolor1"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor2" id="headercolor2"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor3" id="headercolor3"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor4" id="headercolor4"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor5" id="headercolor5"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor6" id="headercolor6"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor7" id="headercolor7"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor8" id="headercolor8"></div>
                    </div>
                </div>
            </div>
            <hr />
            <h6 class="fw-bold mb-0">{{ __('Sidebar Colors')}}</h6>
            <hr />
            <div class="header-colors-indigators">
                <div class="row row-cols-auto g-3">
                    <div class="col">
                        <div class="indigator sidebarcolor1" id="sidebarcolor1"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor2" id="sidebarcolor2"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor3" id="sidebarcolor3"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor4" id="sidebarcolor4"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor5" id="sidebarcolor5"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor6" id="sidebarcolor6"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor7" id="sidebarcolor7"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor8" id="sidebarcolor8"></div>
                    </div>
                </div>
            </div>
            <hr>
            <button id="clearThemeSettings" class="btn btn-danger">{{ __('Clear Theme Settings')}}</button>

        </div>
    </div>
    <!--end switcher-->


    <!-- Bootstrap JS -->
    <script src="/assets/themes/syndron/js/bootstrap.bundle.min.js"></script>
    <!--plugins-->
    <script src="/assets/themes/syndron/js/jquery.min.js"></script>
    <script src="/assets/themes/syndron/plugins/simplebar/js/simplebar.min.js"></script>
    <script src="/assets/themes/syndron/plugins/metismenu/js/metisMenu.min.js"></script>
    <script src="/assets/themes/syndron/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
    <script src="/assets/themes/syndron/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
    <script src="/assets/themes/syndron/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="/assets/themes/syndron/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://unpkg.com/persian-date@latest/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@latest/dist/js/persian-datepicker.min.js"></script>

    <!--app JS-->
    <script src="/assets/themes/syndron/js/app.js"></script>

    @livewireScriptConfig

    @yield('script')

    @if(session('sweetalert'))
    <x-sweetalert2 :json='session("sweetalert")' />
    @endif
    <script>
        // document.addEventListener('DOMContentLoaded', function() {
        //     $(document).ready(function() {
        //         tinymce.init({
        //             selector: 'textarea#.tiny-mce',
        //             plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount fullscreen preview',
        //             toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        //             language: 'fa',
        //         });
        //     });
        // });
    </script>
    @stack('scripts')
</body>

</html>
