<div x-data="shortcutsHeader()" x-init="init()" class="">
    <div class=" py-2">
        <div class="d-flex align-items-center gap-2 flex-wrap">


            <template x-if="items.length === 0">
                <div @click="manageOpen = !manageOpen" style="cursor: pointer;">
                    {{ __('Empty! you can add your shortcut link for quick access. click here' ) }}
                </div>
            </template>

            <!-- Shortcut Pills -->
            <template x-for="item in items" :key="item.id">
                <a class="shortcut-button"
                    :href="item.url" target="_blank" rel="noopener"
                    :style="`background-color:${item.color}73; `">
                    <img :src="favicon(item.url)" alt="" width="16" height="16" class="rounded" />
                    <span class="shortcut-label" x-text="item.title"></span>
                </a>
            </template>

            <div class="vr mx-1 d-none d-md-block"></div>


            <template x-if="items.length > 0">
                <!-- Manage button -->
                <span class="d-flex justify-content-center align-items-center gap-1" style="cursor: pointer;" @click="manageOpen = !manageOpen">
                    <i class="bx bx-edit"></i>

                    {{ __('shortcuts') }}
                </span>
            </template>


        </div>

        <!-- Manage panel -->
        <!-- Manage panel (INLINE add/edit like the table) -->
        <div class="position-fixed top-0 start-0 w-100 h-100 "
            style="background: rgba(0,0,0,.55); backdrop-filter: blur(1px); z-index:13 !important;"
            role="dialog" aria-modal="true" aria-label="Manage Shortcuts"
            @keydown.escape.window="manageOpen=false"
            @click.self="manageOpen=false"
            x-effect="document.body.style.overflow = manageOpen ? 'hidden' : ''"
            x-show="manageOpen" x-cloak x-transition.opacity>


            <div class="d-grid h-100" style="place-items:center;">

                <div class="card card-body p-2" x-ref="managePanel">
                    <!-- Inline Add/Edit Form -->
                    <div class="border-primary border-bottom mb-3">
                        <div class="card-header bg-primary text-white py-2 d-flex justify-content-between align-items-center">
                            <span x-text="form.id ? '{{ __('Edit Shortcut') }}' : '{{ __('Add Shortcut') }}'"></span>
                            <button class="btn btn-sm btn-outline-light" @click="manageOpen = !manageOpen">
                                <i class="bi bi-x-lg"></i> {{ __('Close') }}
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="row g-2">
                                <div class="col-12 col-md-4">
                                    <label class="form-label mb-1">{{ __('Title') }}</label>
                                    <input type="text" class="form-control form-control-sm" x-model.trim="form.title" placeholder="e.g., Woo Admin">
                                </div>
                                <div class="col-12 col-md-6">
                                    <label class="form-label mb-1">{{ __('URL') }}</label>
                                    <input type="url" class="form-control form-control-sm" x-model.trim="form.url" placeholder="https://example.com" dir="ltr">
                                    <div class="form-text" dir="ltr">{{ __('Must start with http:// or https://') }}</div>
                                </div>
                                <div class="col-6 col-md-2">
                                    <label class="form-label mb-1">{{ __('Color') }}</label>
                                    <input type="color" class="form-control form-control-color form-control-sm w-100" x-model="form.color">
                                </div>
                                <div class="col-12  d-flex align-items-end">
                                    <button class="btn btn-sm btn-primary " @click="save()">
                                        <i class="bx bx-save me-1"></i> {{ __('Save') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-sm align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width:36px;"></th>
                                    <th>{{ __("Title") }}</th>
                                    <th>{{ __("URL") }}</th>
                                    <th style="width:110px;">{{ __("Color") }}</th>
                                    <th class="text-end" style="width:160px;">{{ __("Actions") }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <template x-for="(item, idx) in items" :key="item.id">
                                    <tr>
                                        <td class="text-muted">
                                            <img :src="favicon(item.url)" width="18" height="18" class="rounded" alt="" />
                                        </td>
                                        <td x-text="item.title"></td>
                                        <td class="text-truncate" style="max-width:400px;">
                                            <a :href="item.url" target="_blank" rel="noopener" x-text="item.url"></a>
                                        </td>
                                        <td>
                                            <input type="color" class="form-control form-control-color form-control-sm"
                                                x-model="item.color" @change="update(item)" />
                                        </td>
                                        <td class="text-end">
                                            <div class="btn-group btn-group-sm">
                                                <button class="btn btn-outline-secondary" :disabled="idx===0" @click="move(item.id,-1)">
                                                    <i class="bx bx-caret-up"></i>
                                                </button>
                                                <button class="btn btn-outline-secondary" :disabled="idx===items.length-1" @click="move(item.id,1)">
                                                    <i class="bx bx-caret-down"></i>
                                                </button>
                                                <button class="btn btn-outline-primary" @click="openForm(item); $nextTick(()=> $refs.managePanel.scrollIntoView({behavior:'smooth', block:'start'}));">
                                                    <i class="bx bx-edit"></i>
                                                </button>
                                                <button class="btn btn-outline-danger" @click="remove(item.id)">
                                                    <i class="bx bx-trash-alt"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </template>
                                <tr x-show="items.length===0">
                                    <td colspan="5" class="text-center text-muted py-3">No shortcuts yet. Click “Add”.</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
