<?php

use App\Models\Product;
use Livewire\Volt\Component;
use Illuminate\Support\Facades\Artisan;

new class extends Component {

    public $method = null;

    public function execute()
    {

        if ($this->method == null) {
            session()->flash('error', __('no action is selected to execute'));
            return;
        }

        switch ($this->method) {
            case 'update-product-slug-by-title':
                $this->updateProductSlugByTitle();
                session()->flash('success', __('the method executed successfully'));
                break;
            case 'make-product-inventory-infinite':
                $this->makeProductInventoryInfinite();
                session()->flash('success', __('the method executed successfully'));
                break;
            case 'clear-all-cache':
                $this->clearAllCache();
                session()->flash('success', __('the method executed successfully'));
                break;
            case 'all-cache':
                $this->AllCache();
                session()->flash('success', __('the method executed successfully'));
                break;

            default:
                session()->flash('error', __('no action found'));
                break;
        }
    }

    private function clearAllCache()
    {
        Artisan::call("view:clear");
        Artisan::call("cache:clear");
        Artisan::call("config:clear");
        Artisan::call("route:clear");
        Artisan::call("optimize:clear");
        Artisan::call("event:clear");   // Laravel 10+
        Artisan::call("clear-compiled");
    }
    private function AllCache()
    {
        Artisan::call("view:cache");
        Artisan::call("route:cache");
        Artisan::call("config:cache");
        Artisan::call("event:cache");   // Laravel 10+
        Artisan::call("optimize");      // generates optimized caches
    }
    private function updateProductSlugByTitle()
    {
        Product::chunk(500, function ($products) {
            foreach ($products as $product) {
                $slug = Product::generateSlug($product->title);

                $product->updateQuietly([
                    'slug' => $slug,
                ]);
            }
        });
    }
    private function makeProductInventoryInfinite()
    {
        Product::chunk(500, function ($products) {
            foreach ($products as $product) {
                if ($product->inventory === null)
                    $product->updateQuietly([
                        'inventory' => -1,
                    ]);
            }
        });
    }
}; ?>

<div>
    <x-syndron.ui.alert type="warning" title="{{ __('Warning') }}" icon="bx bx-info-circle">
        {{ __('⚠️ Developer Notice: This section is intended for developer use only. Changes here may cause permanent effects that cannot be undone. Make sure to back up anything important before proceeding.') }}
    </x-syndron.ui.alert>

    @session('error')
    <x-syndron.ui.alert type="danger" title="{{ __('error') }}">
        {{ session('error') }}
    </x-syndron.ui.alert>
    @endsession()
    @session('success')
    <x-syndron.ui.alert type="success" title="{{ __('success') }}">
        {{ session('success') }}
    </x-syndron.ui.alert>
    @endsession()


    <div class="row justify-content-between">
        <div class="col-sm-10">
            <select class="w-100 form-select" wire:model="method" name="method" id="">
                <option value="">{{ __('chose') }}</option>
                <option value="update-product-slug-by-title">
                    {{ __('update product slugs by their name') }}
                </option>
                <option value="clear-all-cache">
                    {{ __('clear all cache') }}
                </option>
                <option value="all-cache">
                    {{ __('cache all') }}
                </option>
            </select>
        </div>
        <div class="col-sm-2">
            <button class="w-100 btn btn-primary" wire:click="execute" type="button" wire:click="execute" wire:loading.attr="disabled" wire:target="execute">

                <span wire:loading.class="d-none">
                    {{ __('execute') }}
                </span>

                <div wire:loading>

                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>

                    {{ __("loading...") }}
                </div>
            </button>
        </div>
    </div>
</div>
