<div class="row mt-3">
    @foreach ($disksData as $disk)
    <div class="col-12 col-lg-4">
        <div class="card shadow-none border radius-15">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="fm-icon-box radius-15 {{ $disk['bg'] }}">
                        <i class="{{ $disk['icon'] }}"></i>
                    </div>
                    <div class="ms-auto font-24"><i class='bx bx-dots-horizontal-rounded'></i></div>
                </div>
                <h5 class="mt-3 mb-0">{{ $disk['name'] }}</h5>
                <p class="mb-1 mt-4">
                    <span>{{ number_format(($disk['used'] ?? 0) / (1024 ** 3), 2) }} GB</span>
                    <span class="float-end">{{ number_format($disk['max'] / (1024 ** 3)) }} GB</span>
                </p>
                <div class="progress" style="height: 7px;">
                    <div class="progress-bar {{ $disk['bg'] }}" role="progressbar"
                        style="width:  <?php echo $disk['percent'] ?? 0; ?>%;" aria-valuenow="{{ $disk['percent'] ?? 0 }}"
                        aria-valuemin="0" aria-valuemax="100">
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>
