<div class="z-10 w-full py-10 xs:container">
    <div class="relative mx-auto bg-muted px-4 py-8 xs:max-w-[440px] xs:rounded-xl lg:px-10 lg:py-12">
        <!-- Return previous Section -->
        <button onclick="Livewire.dispatch('showIdentifierStep')" class="absolute right-2 top-2 flex size-10 items-center justify-center rounded-full border bg-background text-primary duration-300 hover:bg-primary-btn hover:text-background xs:-right-2 xs:-top-2">
            <i class="i-carbon-chevron-right size-7 stroke-2"></i>
        </button>
        <div class="flex flex-col">
            <!-- logo -->
            <a href="{{ route('home') }}" class="mb-10">
                <img src="{{ asset('uploads/'.getSiteLogo()) }}" alt="logo" class="mx-auto h-10 xs:h-12" />
            </a>

            <h1 class="mb-8 text-center font-medium xs:text-lg">{{ __('please enter your password') }}</h1>

            <!-- password -->
            <div class="mb-4 w-full space-y-3">
                <label for="password" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="password" wire:keydown.prevent.enter="handle" dir="ltr" type="password" id="password" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5"> </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    @error('password') {{ $message }} @enderror
                    @error('error') {{ $message }} @enderror
                </p>
            </div>
            <ul class="mb-6 space-y-4">
                <li>
                    <a href="#" class="flex items-center gap-1 text-sm text-primary duration-200 hover:text-primary/80">
                        {{ __('Login in with OTP code') }}
                        <i class="i-carbon-chevron-left size-4"></i>
                    </a>
                </li>
                <li>
                    <a href="#" class="flex items-center gap-1 text-sm text-primary duration-200 hover:text-primary/80">
                        {{ __('Forgot my password!') }}
                        <i class="i-carbon-chevron-left size-4"></i>
                    </a>
                </li>
            </ul>

            <button wire:click="handle" wire:loading.attr="disabled" wire:target="handle" type="button" class="btn-primary py-3">
                {{ __('login') }}
                <div wire:loading class="i-lucide-loader-circle animate-spin"></div>
            </button>
        </div>
    </div>
</div>
