@extends('layouts.syndron.app')

@section('style')
<style>
    .toggle-children {
        transition: transform 0.3s ease;
    }
</style>
@endsection

@section('content')
<section>
    <x-syndron.breadcrumb title="{{ __('Categories') }}">
        <x-syndron.breadcrumb-item active>
            {{ __(key: 'Categories') }}
        </x-syndron.breadcrumb-item>
    </x-syndron.breadcrumb>

    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <div></div>
            <div class=" d-flex gap-1 ">
                <a href="{{ route('admin.categories.create') }}" class="btn btn-success">
                    {{ __('create a new category') }}
                </a>
            </div>
        </div>
        <div class="card-body">
            <x-syndron.elements.category-tree :categories="$categories" />
        </div>
    </div>
</section>
@endsection


@section('script')
<script>
    document.addEventListener('click', function(e) {
        const btn = e.target.closest('.toggle-children');
        if (!btn) return;

        const li = btn.closest('li.list-group-item');
        if (!li) return;

        const childList = li.querySelector(':scope > ul.list-group');
        if (!childList) return;

        const isHidden = childList.classList.toggle('d-none'); // Bootstrap: hide/show
        btn.setAttribute('aria-expanded', (!isHidden).toString());
        btn.style.transform = isHidden ? 'rotate(0deg)' : 'rotate(-90deg)';
    });
</script>

@endsection
