@extends('layouts.syndron.app')

@section('content')
<x-syndron.breadcrumb title="{{ __('Categories') }}">
    <x-syndron.breadcrumb-item url="{{ route('admin.categories.index') }}">
        {{ __('Categories') }}
    </x-syndron.breadcrumb-item>

    <x-syndron.breadcrumb-item active>
        {{ __(key: 'Category') }} : {{ $category->name ?? '' }}
    </x-syndron.breadcrumb-item>
</x-syndron.breadcrumb>


<section>
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <h4>{{ __('Category Details') }}</h4>
            <div class="d-flex gap-1">
                <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">{{ __('Back to List') }}</a>
                <a href="{{ route('admin.categories.edit', $category) }}" class="btn btn-primary">{{ __('Edit Category') }}</a>
                <form action="{{ route('admin.categories.destroy', $category) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this coupon?') ?>');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">{{ __('Delete') }}</button>
                </form>
            </div>
        </div>
        <div class="card-body">
            <div class="mb-3">
                <strong>{{ __('Name') }}:</strong>
                <p>{{ $category->name }}</p>
            </div>

            @if($category->image)
            <div class="mb-3">
                <strong>{{ __('Image') }}:</strong>
                <div>
                    <img src="{{ asset('uploads/' . $category->image) }}" alt="{{ $category->name }}" data-scope="category" onerror="app.handleBrokenImage(this)" class="img-thumbnail" style="max-height: 200px; border-radius: 5px;">
                </div>
            </div>
            @endif

            <div class="mb-3">
                <strong>{{ __('Commission') }}:</strong>
                <p>{{ $category->commission }}%</p>
            </div>

            <div class="mb-3">
                <strong>{{ __('Order Index') }}:</strong>
                <p>{{ $category->order_index }}</p>
            </div>

            @if($category->parent)
            <div class="mb-3">
                <strong>{{ __('Parent Category') }}:</strong>
                <p><a href="{{ route('admin.categories.show', $category->parent) }}">{{ $category->parent->name }}</a></p>
            </div>
            @endif

            @if($category->children->isNotEmpty())
            <div class="mb-3">
                <strong>{{ __('Child Categories') }}:</strong>
                <ul class="list-group">
                    @foreach($category->children as $child)
                    <li class="list-group-item">
                        <a href="{{ route('admin.categories.show', $child) }}">{{ $child->name }}</a>
                    </li>
                    @endforeach
                </ul>
            </div>
            @endif

            @if($category->attributes->isNotEmpty())
            <div class="mb-3">
                <strong>{{ __('Attributes') }}:</strong>
                <ul class="list-group">
                    @foreach($category->attributes as $attribute)
                    <li class="list-group-item">{{ $attribute->name }}</li> {{-- Assuming CategoryAttribute has a 'name' property --}}
                    @endforeach
                </ul>
            </div>
            @endif

        </div>
    </div>
</section>
@endsection
