@extends('layouts.syndron.app')

@section('content')
@php
$columns = [
    'item group',
    'item key',
    'item value',
    'actions',
];
@endphp
<x-syndron.breadcrumb title="{{ __('attribute values') }}">
    <x-syndron.breadcrumb-item url="{{ route('admin.categories.index') }}">
        {{ __(key: 'Categories') }}
        ({{ $attribute->category->name ?? '' }})

    </x-syndron.breadcrumb-item>
    <x-syndron.breadcrumb-item url="{{ route('admin.category.attribute.index', $attribute->category->id) }}">
        {{ __(key: 'Attributes') }}
        ({{ $attribute->label ?? '' }})
    </x-syndron.breadcrumb-item>
    <x-syndron.breadcrumb-item active>
        {{ __(key: 'attribute values') }}
    </x-syndron.breadcrumb-item>
</x-syndron.breadcrumb>


<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div class="">

        </div>
        <div>
            <a href="{{ route('admin.attribute.item.create' , $attribute->id) }}" class="btn btn-success">
                {{ __('create a new attribute item') }}
            </a>
        </div>
    </div>
    <div class="card-body">
        <x-syndron.ui.table :columns="$columns">
            @foreach ($items as $item )
            <tr>
                <td>{{ $item->item_group  }}</td>
                <td>{{ $item->item_key  }}</td>
                <td>{{ $item->item_value  }}</td>

                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @if (false)
                            <li><a class="dropdown-item" href="{{ route('admin.attribute.item.edit', [$attribute->id, $item->id]) }}">{{__('Edit')}}</a></li>
                            @endif
                            @can('category.attribute.item.delete')
                            <li>
                                <form action="{{ route('admin.attribute.item.destroy', ['attribute' => $attribute->id,'item'=> $item->id]) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>

@endsection
