@extends('layouts.admin')

@section('content')
<div class="container">
    <h1>{{ __('Edit Delivery') }}</h1>
    <form action="{{ route('admin.deliveries.update', $delivery) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="provider_id" class="form-label">{{ __('Provider ID') }}</label>
            <input type="number" name="provider_id" id="provider_id" class="form-control" value="{{ old('provider_id', $delivery->provider_id) }}" required>
        </div>
        <div class="mb-3">
            <label for="slot_id" class="form-label">{{ __('Slot ID') }}</label>
            <input type="number" name="slot_id" id="slot_id" class="form-control" value="{{ old('slot_id', $delivery->slot_id) }}" required>
        </div>
        <div class="mb-3">
            <label for="status" class="form-label">{{ __('Status') }}</label>
            <input type="text" name="status" id="status" class="form-control" value="{{ old('status', $delivery->status) }}" required>
        </div>
        <div class="mb-3">
            <label for="tracking_code" class="form-label">{{ __('Tracking Code') }}</label>
            <input type="text" name="tracking_code" id="tracking_code" class="form-control" value="{{ old('tracking_code', $delivery->tracking_code) }}">
        </div>
        <button type="submit" class="btn btn-success">{{ __('Update') }}</button>
        <a href="{{ route('admin.deliveries.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
    </form>
</div>
@endsection
