@extends('layouts.admin')
@section('content')
<div class="container">
    <h1>{{ __('Delivery Events') }}</h1>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Delivery ID</th>
                <th>Event Type</th>
                <th>Created At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($events as $event)
            <tr>
                <td>{{ $event->id }}</td>
                <td>{{ $event->delivery_id }}</td>
                <td>{{ $event->type ?? '' }}</td>
                <td>{{ $event->created_at }}</td>
                <td>
                    @can('delivery.event.delete')
                    <form action="{{ route('admin.deliveries.delivery-events.destroy', [$delivery, $event]) }}" method="POST" style="display:inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('<?php echo __('Are you sure?') ?>')">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    <a href="{{ route('admin.deliveries.index') }}" class="btn btn-secondary">{{ __('Back to Deliveries') }}</a>
</div>
@endsection
