@extends('layouts.syndron.app')
@section('content')

<div class="card">
    <div class="card-body">
        <x-syndron.ui.table :columns="['ID','Delivery ID','Order Item ID','Actions']">
            @foreach($items as $item)
            <tr>
                <td>{{ $item->id }}</td>
                <td>{{ $item->delivery_id }}</td>
                <td>{{ $item->order_item_id }}</td>
                <td>
                    @can('delivery.item.view')
                    <a href="{{ route('admin.delivery.delivery-items.edit', $item) }}" class="btn btn-warning btn-sm">{{ __('Edit') }}</a>
                    @endcan
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
