@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Delivery Time Exceptions') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.delivery.time.exceptions.create' , $time->id) }}">
                {{ __('Create a new Delivery Time Exceptions') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['date','action']">
            @foreach ($deliveryTimeExceptions as $timeExceptions )
            <tr>
                <td>{{ $timeExceptions->date  }}</td>

                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('delivery.exceptions.edit')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.delivery.exceptions.edit' , $timeExceptions->id) }}">
                                    {{ __('Edit') }}
                                </a>
                            </li>
                            @endcan

                            @can('delivery.exceptions.delete')
                            <li>
                                <form action="{{ route('admin.delivery.exceptions.destroy' , $timeExceptions->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this times?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
