@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4>{{ __('Question Details') }}</h4>
        <div>
            <a href="{{ route('admin.faq.questions.edit', $question->id) }}" class="btn btn-primary btn-sm">{{ __('Edit') }}</a>
            <form action="{{ route('admin.faq.questions.destroy', $question->id) }}" method="POST" class="d-inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('<?php echo __('Are you sure?') ?>')">{{ __('Delete') }}</button>
            </form>
        </div>
    </div>
    <div class="card-body">
        <p><strong>{{ __('Title:') }}</strong> {{ $question->title }}</p>
        <p><strong>{{ __('Slug:') }}</strong> {{ $question->slug }}</p>
        <p><strong>{{ __('Body:') }}</strong> {{ $question->body }}</p>
        <p><strong>{{ __('Category:') }}</strong> {{ \Artemis\Faq\Models\Category::find($question->category_id)->name }}</p>
        <p><strong>{{ __('Status:') }}</strong> {{ $question->status }}</p>
        <p><strong>{{ __('User ID:') }}</strong> {{ $question?->user->name }}</p>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        <h5>{{ __('Answers') }}</h5>
    </div>
    <div class="card-body">
        @forelse($question->answers as $answer)
        <div class="mb-4 border-bottom pb-3">
            <p><strong>{{ __('Answer by:') }}</strong> {{ $answer->user?->name ?? __('Unknown') }}</p>
            <p>{{ $answer->body }}</p>
            <div class="ms-3">
                <strong>{{ __('Comments:') }}</strong>
                @forelse($answer->comments as $comment)
                <div class="border rounded p-2 my-1">
                    <small><strong>{{ $comment->user?->name ?? __('Unknown') }}:</strong></small>
                    <span>{{ $comment->body }}</span>
                </div>
                @empty
                <p class="text-muted">{{ __('No comments.') }}</p>
                @endforelse
            </div>
        </div>
        @empty
        <p>{{ __('No answers yet.') }}</p>
        @endforelse
    </div>
</div>

@endsection
