@extends('layouts.syndron.app')


@section('content')
<div class="card">
    <div class="row g-0">

        <div x-data="{image : '{{ $product->brand_img }}' }" class="col-md-4 border-end">
            <img x-bind:src="image" class="img-fluid w-100 square-box" alt="{{$product->title}}">
            <div class="row mb-3 row-cols-auto g-2 justify-content-center mt-3">
                @foreach ($product->getMetaByKey('gallery') as $image )
                <div class="col">
                    <img x-on:click="image = '{{  $image->value }}' " src="{{ $image->value }}" width="70" class="square-box border rounded cursor-pointer" alt="">
                </div>
                @endforeach
            </div>
        </div>


        <div class="col-md-8">
            <div class="card-body">
                <h4 class="card-title">
                    {{ $product->title }}
                </h4>

                <!-- Todo: d-flex  -->
                <div class="d-none gap-3 py-3">
                    <div class="cursor-pointer">
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-warning'></i>
                        <i class='bx bxs-star text-secondary'></i>
                    </div>
                    <div>142 reviews</div>
                    <div class="text-success"><i class='bx bxs-cart-alt align-middle'></i> 134 orders
                    </div>
                </div>


                <div class="mb-3">
                    <span class="price h4">
                        <span @if($product->discount_price) class="me-2 text-decoration-line-through text-secondary" @endif>
                            {{ is_numeric($product->price) ? number_format($product->price) : $product->price }}
                        </span>
                        <span>
                            {{ is_numeric($product->discount_price) ? number_format($product->discount_price) : $product->discount_price }}
                        </span>
                    </span>
                </div>


                <p class="card-text fs-6">
                    {{ $product->short_description }}
                </p>
                <dl class="row">
                    @forelse ($product->attribute as $attribute)
                    <dt class="col-sm-3">
                        {{ $attribute->attribute->label }}
                    </dt>
                    <dd class="col-sm-9">
                        {{ $attribute->value }}
                    </dd>
                    @empty

                    @endforelse

                </dl>
                <hr>
                <div class="d-flex">
                    <a href="{{ route('product.details' , $product->slug) }}" class="btn btn-secondary" target="_blank"> {{ __('see product in shop') }} </a>

                    @if (auth()->user()->isAdmin())
                    <a href="{{ route('admin.product.edit' , ['product'=>$product->id ]) }}" class="btn btn-secondary ms-2">
                        {{ __('Edit') }}
                    </a>
                    <form action="{{ route('admin.product.destroy' , $product->id) }}" method="post" class="ms-2" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this product?') ?>');">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger">
                            {{ __('Delete') }}
                        </button>
                    </form>
                    @endif
                </div>
                <hr>

                @if (Route::is('admin.shop.add.inventory'))
                <div class="">
                    <h3>
                        {{ __('add this product to my inventory') }}
                    </h3>

                    <form action="{{ route('admin.shop.inventory.store') }}" method="post">
                        @csrf
                        <input type="text" name="product_id" value="{{ $product->id }}" hidden>
                        <div class="mb-3">
                            <x-syndron.ui.form.number-input />
                            @error('quantity')
                            <small class="text-danger"> {{ $message }} </small>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="price">{{ __('Price') }}</label>
                            <input type="text" name="price" class="form-control" id="price" value="{{ $product->price }}" placeholder="{{ __('Price') }}">
                            @error('price')
                            <small class="text-danger"> {{ $message }} </small>
                            @enderror
                        </div>
                        <div class="d-flex justify-content-end">
                            <button class="btn btn-primary" type="submit">
                                {{ __('Add to my inventory') }}
                            </button>

                        </div>
                    </form>

                </div>
                @endif

                <!-- d-flex -->
                <div class="d-none  gap-3 mt-3">
                    <a href="#" class="btn btn-primary">Buy Now</a>
                    <a href="#" class="btn btn-outline-primary"><span class="text">Add to cart</span> <i
                            class='bx bxs-cart-alt'></i></a>
                </div>
                <!-- todo -->
            </div>
        </div>
    </div>

    <hr />

    <div class="card-body">
        <ul class="nav nav-tabs nav-primary mb-0" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link active" data-bs-toggle="tab" href="#primaryhome" role="tab"
                    aria-selected="true">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='bx bx-comment-detail font-18 me-1'></i>
                        </div>
                        <div class="tab-title"> {{ __('Product Description') }} </div>
                    </div>
                </a>
            </li>

            <li class="nav-item" role="presentation">
                <a class="nav-link" data-bs-toggle="tab" href="#primarycontact" role="tab"
                    aria-selected="false">
                    <div class="d-flex align-items-center">
                        <div class="tab-icon"><i class='bx bx-star font-18 me-1'></i>
                        </div>
                        <div class="tab-title">Reviews</div>
                    </div>
                </a>
            </li>
        </ul>

        <div class="tab-content pt-3">
            <div class="tab-pane fade show active" id="primaryhome" role="tabpanel">
                {!! $product->content !!}
            </div>

            <div class="tab-pane fade" id="primarycontact" role="tabpanel">

            </div>
        </div>
    </div>

</div>
@endsection
