@extends('layouts.syndron.app')

@section('title', 'Shop Profiles')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">{{ __('Shop Profiles') }}</h1>
        <a href="{{ route('admin.shops.create') }}" class="btn  btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> {{ __('Create New Shop') }}
        </a>
    </div>

    @if (session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('Shops List') }}</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered align-middle text-center" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>{{ __('Logo') }}</th>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Owner') }}</th>
                            <th>{{ __('Email') }}</th>
                            <th>{{ __('Phone') }}</th>
                            <th>{{ __('Approved') }}</th>
                            <th>{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($shops as $shop)
                        <tr>
                            <td>
                                @if ($shop->logo)
                                <img data-scope="shop-profile" onerror="window.app.handleBrokenImage(this)" src="{{ asset('uploads/' . $shop->logo) }}" alt="{{ $shop->name }}" style="max-height: 50px; max-width: 100px;">
                                @else
                                N/A
                                @endif
                            </td>
                            <td>{{ $shop->name }}</td>
                            <td>{{ $shop->user?->name ?? 'N/A' }}</td>
                            <td>{{ $shop->email }}</td>
                            <td>{{ $shop->phone }}</td>
                            <td class="d-flex flex-wrap justify-content-around align-items-center">
                                @if ($shop->is_approved)
                                <span class="badge bg-success">{{ __('Yes') }}</span>
                                @can('shop.profile.unapprove')
                                <form action="{{ route('admin.shops.unapprove', $shop) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to unapprove this shop?');">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="btn  btn-warning">{{ __('Unapprove')}}</button>
                                </form>
                                @endcan
                                @else
                                <span class="badge bg-danger">{{ __('No') }}</span>
                                @can('shop.profile.approve')
                                <form action="{{ route('admin.shops.approve', $shop) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to approve this shop?');">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="btn  btn-success">{{ __('Approve')}}</button>
                                </form>
                                @endcan

                                @endif
                            </td>
                            <td class="">
                                <div class="d-flex flex-wrap justify-content-around align-items-center">
                                    <a href="{{ route('admin.shops.show', $shop) }}" class="btn  btn-info" title="View"><i class="bx bxs-show m-0 p-0"></i></a>
                                    <a href="{{ route('admin.shops.edit', $shop) }}" class="btn  btn-warning" title="Edit"><i class="bx bxs-edit m-0 p-0"></i></a>
                                    <form action="{{ route('admin.shops.destroy', $shop) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this shop? This action cannot be undone.');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn  btn-danger" title="Delete"><i class="bx bxs-trash m-0 p-0"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="text-center">{{ __('No shops found.')}}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center">
                {{ $shops->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
