@extends('layouts.syndron.app')


@section('style')

<style>
    .woo-section {
        max-height: 400px;
    }

    .woo-image {
        height: 400px;
        padding: 0;
        margin: 0;
    }
</style>
@endsection

@section('content')


<section class="">
    <h3>{{ __('Orders Overview') }}</h3>
    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-5">
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$newOrdersCount" :title="__('new')" trend="info" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$todayOrdersCount" :title="__('Today')" trend="success" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$thisMonthOrdersCount" :title="__('This Month')" trend="secondary" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$totalOrdersCount" :title="__('total')" trend="primary" />
        </div>
        <div class="p-2">
            <x-syndron.elements.widgets.static-card :amount="$abandonedOrdersCount" :title="__('abandoned')" trend="warning" />
        </div>
    </div>
</section>

<section class="">
    <h3>{{ __('sales Overview') }}</h3>
    <div class="row">
        <div class="col-sm-12 col-md-7 col-lg-9">
            <div class="card radius-10 w-100">
                <div class="card-body">
                    <p class="font-weight-bold mb-1 text-secondary">Sales</p>
                    <div class="d-flex align-items-center">
                        <div>
                            <!-- <h4 class="mb-0">43,540</h4> -->
                        </div>
                        <div class="">
                            <!-- <p class="mb-0 align-self-center font-weight-bold text-success ms-2">4.4 <i class="bx bxs-up-arrow-alt mr-2"></i></p> -->
                        </div>
                    </div>
                    <div id="chart21"></div>
                </div>
            </div>
        </div>
        <div class="d-flex flex-column  gap-2 col-sm-12 col-md-5 col-lg-3">
            <x-syndron.elements.widgets.static-card :amount="$todaySales" :title="__('Today')" trend="info" />
            <x-syndron.elements.widgets.static-card :amount="$monthSales" :title="__('This Month')" trend="success" />
            <x-syndron.elements.widgets.static-card :amount="$totalSales" :title="__('Total')" trend="secondary" />
        </div>
    </div>
</section>

@endsection

@section('script')
<script>
    e = {
        series: [{
            name: "Sales",
            data: <?php echo json_encode($monthlySales); ?>
        }],
        chart: {
            foreColor: "#6c757d",
            type: "bar",
            height: 390,
            toolbar: {
                show: !1
            },
            zoom: {
                enabled: !1
            },
            dropShadow: {
                enabled: !1,
                top: 3,
                left: 10,
                blur: 3,
                opacity: .1,
                color: "#0d6efd"
            },
            sparkline: {
                enabled: !1
            }
        },
        plotOptions: {
            radialBar: {
                hollow: {
                    size: "70%"
                }
            },
            bar: {
                horizontal: !1,
                columnWidth: "35%",
                endingShape: "rounded"
            }
        },
        markers: {
            size: 0,
            colors: ["#0d6efd"],
            strokeColors: "#fff",
            strokeWidth: 2,
            hover: {
                size: 7
            }
        },
        dataLabels: {
            enabled: !1
        },
        stroke: {
            show: !0,
            width: 3,
            curve: "smooth"
        },
        colors: ["#0d6efd"],
        xaxis: {
            categories: <?php echo json_encode($months); ?>
        },
        grid: {
            show: true,
            borderColor: 'rgba(0, 0, 0, 0.15)',
            strokeDashArray: 4,
        },
        fill: {
            opacity: 1
        }
    };
    new ApexCharts(document.querySelector("#chart21"), e).render();
</script>
@endsection
