@extends('layouts.syndron.app')

@section('content')
<div class="container py-5" dir="rtl">
    <div class="row justify-content-center">
        <div class="col-lg-7">
            <div class="card shadow-sm border-0">
                <div class="card-body p-4">
                    <h2 class="fw-bold mb-3 text-primary text-center">فرم تماس با ما</h2>
                    <p class="text-muted text-center mb-4">
                        لطفاً فرم زیر را پر کنید. تیم ما در سریع‌ترین زمان ممکن پاسخگوی شما خواهد بود.
                    </p>

                    <form>
                        <div class="mb-3">
                            <label for="name" class="form-label">نام و نام خانوادگی</label>
                            <input type="text" class="form-control" id="name" placeholder="نام خود را وارد کنید">
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">ایمیل</label>
                            <input type="email" class="form-control" id="email" placeholder="example@mail.com">
                        </div>

                        <div class="mb-3">
                            <label for="phone" class="form-label">شماره تماس</label>
                            <input type="text" class="form-control" id="phone" placeholder="0912xxxxxxx">
                        </div>

                        <div class="mb-3">
                            <label for="subject" class="form-label">موضوع</label>
                            <input type="text" class="form-control" id="subject" placeholder="موضوع پیام شما">
                        </div>

                        <div class="mb-3">
                            <label for="message" class="form-label">متن پیام</label>
                            <textarea class="form-control" id="message" rows="5" placeholder="پیام یا پیشنهاد خود را اینجا بنویسید..."></textarea>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <button type="submit" class="btn btn-primary">ارسال پیام</button>
                            <button type="reset" class="btn btn-outline-secondary">پاک کردن</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Info Section -->
            <div class="text-center mt-4">
                <p class="small text-muted mb-1">همچنین می‌توانید از طریق ایمیل مستقیم با ما در ارتباط باشید:</p>
                <a href="mailto:mailto:e-commerce@alireza-hadizadeh.ir" class="btn btn-success">ارسال ایمیل مستقیم</a>
            </div>
        </div>
    </div>
</div>
@endsection
