@extends('layouts.syndron.app')

@section('content')
<!-- Admin Dashboard Tasks Form -->
<section id="admin-dashboard-tasks" class="container my-5">
    <h2 class="mb-4">لیست تسک‌های مدیریت</h2>
    <form action="/admin/tasks/complete" method="post">
        <div class="row gy-4">
            <!-- داشبورد -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">
                        داشبورد
                    </div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-new-orders" name="tasks" value="new-orders">
                            <label class="form-check-label" for="task-new-orders">
                                تعداد سفارشات جدید
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-today-orders" name="tasks" value="today-orders">
                            <label class="form-check-label" for="task-today-orders">
                                تعداد سفارشات امروز
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-month-orders" name="tasks" value="month-orders">
                            <label class="form-check-label" for="task-month-orders">
                                تعداد سفارشات این ماه
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-total-orders" name="tasks" value="total-orders">
                            <label class="form-check-label" for="task-total-orders">
                                تعداد سفارشات کل
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-abandoned-orders" name="tasks" value="abandoned-orders">
                            <label class="form-check-label" for="task-abandoned-orders">
                                تعداد سفارشات رها شده
                            </label>
                        </div>
                        <div class="form-check mt-3">
                            <input class="form-check-input" type="checkbox" id="task-sales-today" name="tasks" value="sales-today">
                            <label class="form-check-label" for="task-sales-today">
                                میزان فروش امروز
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-sales-month" name="tasks" value="sales-month">
                            <label class="form-check-label" for="task-sales-month">
                                میزان فروش این ماه
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-sales-total" name="tasks" value="sales-total">
                            <label class="form-check-label" for="task-sales-total">
                                میزان فروش کل
                            </label>
                        </div>
                        <div class="form-check mt-3">
                            <input class="form-check-input" type="checkbox" id="task-sales-chart" name="tasks" value="sales-chart">
                            <label class="form-check-label" for="task-sales-chart">
                                نمودار فروش بر اساس دسته‌بندی
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-suppliers-count" name="tasks" value="suppliers-count">
                            <label class="form-check-label" for="task-suppliers-count">
                                تعداد تامین‌کننده‌ها
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-suppliers-pending" name="tasks" value="suppliers-pending">
                            <label class="form-check-label" for="task-suppliers-pending">
                                تامین‌کننده‌های در انتظار تایید
                            </label>
                        </div>
                        <div class="form-check mt-3">
                            <input class="form-check-input" type="checkbox" id="task-products-count" name="tasks" value="products-count">
                            <label class="form-check-label" for="task-products-count">
                                تعداد محصولات
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-products-pending" name="tasks" value="products-pending">
                            <label class="form-check-label" for="task-products-pending">
                                محصولات در انتظار تایید
                            </label>
                        </div>
                        <div class="form-check mt-3">
                            <input class="form-check-input" type="checkbox" id="task-reviews-count" name="tasks" value="reviews-count">
                            <label class="form-check-label" for="task-reviews-count">
                                تعداد نظرات
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-reviews-pending" name="tasks" value="reviews-pending">
                            <label class="form-check-label" for="task-reviews-pending">
                                نظرات در انتظار تایید
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- تامین‌کنندگان -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">تامین‌کنندگان</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-suppliers-list" name="tasks" value="suppliers-list">
                            <label class="form-check-label" for="task-suppliers-list">لیست تامین‌کنندگان</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-supplier-detail" name="tasks" value="supplier-detail">
                            <label class="form-check-label" for="task-supplier-detail">جزئیات تامین‌کننده</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- محصولات -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">مدیریت محصولات</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-categories" name="tasks" value="categories">
                            <label class="form-check-label" for="task-categories">دسته‌بندی‌ها</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-upload-limit" name="tasks" value="upload-limit">
                            <label class="form-check-label" for="task-upload-limit">محدودیت آپلود عکس</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-bulk-upload" name="tasks" value="bulk-upload">
                            <label class="form-check-label" for="task-bulk-upload">ورودی محصول (Excel)</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-filter-products" name="tasks" value="filter-products">
                            <label class="form-check-label" for="task-filter-products">فیلترینگ محصولات</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- سفارش‌ها -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">مدیریت سفارش‌ها</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-edit-order" name="tasks" value="edit-order">
                            <label class="form-check-label" for="task-edit-order">تغییر وضعیت و ویرایش</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-filter-order" name="tasks" value="filter-order">
                            <label class="form-check-label" for="task-filter-order">فیلترینگ سفارش‌ها</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-generate-invoice" name="tasks" value="generate-invoice">
                            <label class="form-check-label" for="task-generate-invoice">ساخت فاکتور</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- مرجوعی‌ها -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">مرجوعی‌ها</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-manage-returns" name="tasks" value="manage-returns">
                            <label class="form-check-label" for="task-manage-returns">مدیریت مرجوعی‌ها</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- حمل‌ونقل -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">حمل‌ونقل (تی‌پاکس)</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-tipax" name="tasks" value="tipax-settings">
                            <label class="form-check-label" for="task-tipax">تنظیمات تی‌پاکس</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- مالی -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">مدیریت مالی</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-finance-report" name="tasks" value="finance-report">
                            <label class="form-check-label" for="task-finance-report">گزارش تراکنش‌ها</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-finance-dashboard" name="tasks" value="finance-dashboard">
                            <label class="form-check-label" for="task-finance-dashboard">داشبورد مالی</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- پشتیبانی -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">پشتیبانی و شکایات</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-tickets" name="tasks" value="tickets">
                            <label class="form-check-label" for="task-tickets">تیکت‌ها</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-complaints" name="tasks" value="complaints">
                            <label class="form-check-label" for="task-complaints">رسیدگی به شکایات</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- پنل تامین‌کننده -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100">
                    <div class="card-header">پنل تامین‌کننده</div>
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-edit-profile" name="tasks" value="edit-profile">
                            <label class="form-check-label" for="task-edit-profile">ویرایش پروفایل</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="task-social" name="tasks" value="social-links">
                            <label class="form-check-label" for="task-social">شبکه‌های اجتماعی</label>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- Submit Button -->
        <div class="text-center mt-4">
            <button type="submit" class="btn btn-primary">ذخیره وضعیت تسک‌ها</button>
        </div>
    </form>
</section>

@endsection
