@extends('layouts.syndron.app')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <h5 class="">
                {{ __('Warehouses') }}
            </h5>
        </div>
        <div>
            <a href="{{ route('admin.warehouses.create') }}" class="btn btn-success btn-sm d-flex justify-content-center align-items-center">
                <i class="bx bx-plus-circle"></i> {{ __('Add New Warehouse') }}
            </a>
        </div>
    </div>
    <div class="card-body">
        <x-syndron.ui.table :columns="['name' , 'code' , 'is_active' ,'address']">
            @foreach ($warehouses as $warehouse)
            <tr>
                <td>{{ $warehouse->name }}</td>
                <td>{{ $warehouse->code }}</td>
                <td>{{ $warehouse->is_active ? __('Yes') : __('No') }}</td>
                <td>{{ collect($warehouse->address)->implode('-') }}</td>

                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">

                            <li><a class="dropdown-item" href="{{ route('admin.warehouse.inventory.index' , $warehouse->id) }}">{{ __('Inventories') }}</a></li>
                            @can('update', $warehouse)
                            <li><a class="dropdown-item" href="{{ route('admin.warehouses.edit' , $warehouse->id) }}">{{ __('Edit') }}</a></li>
                            @endcan

                            @can('delete', $warehouse)
                            <li>
                                <form action="{{ route('admin.warehouses.destroy' , $warehouse->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
