@extends('pages.admin.woo-commerce.woo-app')

@section('woo-content')
<div>
    <table id="" class="table dataTable woo-data-table text-start align-middle">
        <thead>
            <tr>
                <th>#</th>
                <th>{{ __('order number') }}</th>
                <th>{{ __('customer') }}</th>
                <th>{{ __('status') }}</th>
                <th>{{ __('total') }}</th>
                <th>{{ __('date created') }}</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($orders as $order)
            <tr>
                <td class="text-start">
                    {{ $loop->iteration }}
                </td>
                <td>
                    {{ $order->number }}
                </td>
                <td>
                    {{-- Show billing name if exists, else customer_id --}}
                    @if ($order->billing?->firstName || $order->billing?->lastName)
                    {{ $order->billing?->firstName }} {{ $order->billing?->lastName }}
                    @else
                    #{{ $order->customerId }}
                    @endif
                </td>
                <td>
                    <span class="badge bg-info text-dark">
                        {{ $order->status }}
                    </span>
                </td>
                <td>
                    {{ $order->total }} {{ $order->currency }}
                </td>
                <td>
                    {{ $order->dateCreated?->format('Y-m-d H:i') }}
                </td>
                <td>
                    <a class="btn btn-sm btn-secondary"
                        href="">
                        {{ __('view details') }}
                    </a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
