@extends('pages.admin.woo-commerce.woo-app')

@section('woo-content')
<div>
    <table id="" class="table dataTable woo-data-table text-start align-middle">
        <thead>
            <tr>
                <th>#</th>
                <th>{{ __('images') }}</th>
                <th>{{ __('name') }}</th>
                <th>{{ __('status') }}</th>
                <th>{{ __('sku') }}</th>
                <th>{{ __('price') }}</th>
                <th></th>

            </tr>
        </thead>
        <tbody>
            @foreach ($products as $product )
            <tr>
                <td class="text-start">
                    {{ $loop->iteration }}
                </td>
                <td>
                    <img src="{{ $product->images->first()->src }}" alt="{{ $product->name }}" class="table-image">
                </td>
                <td>
                    {{ $product->name }}
                </td>

                <td>
                    {{ $product->status }}
                </td>
                <td>
                    {{ $product->sku }}
                </td>
                <td>
                    {{ $product->price }}
                </td>
                <td>
                    <a class="btn btn-sm btn-secondary" href="{{ $product->permalink }}" target="_blank">
                        {{ __('product url') }}
                    </a>
                </td>
            </tr>
            @endforeach

        </tbody>
    </table>
</div>
@endsection








// first()->scr
