@extends('layouts.syndron.app')

@section('content')
<div class="container py-5" dir="rtl">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card shadow-sm border-0">
                <div class="card-body p-4">
                    <h2 class="fw-bold mb-4 text-center text-primary">
                        {{ __('connect your woocommerce shop') }}
                    </h2>
                    <p class="text-muted text-center mb-4">
                        {{ __('Please enter the information below to connect your WooCommerce store to the system.') }}
                    </p>

                    @if (auth()->user()->shop->isShopWooCommerceCredentialExist() === true)
                    <div class="alert alert-success" role="alert">
                        <strong>{{ __('Congratulations') }}</strong>
                        <p class="mb-0 pb-0">
                            {{ __('You have connected your WooCommerce store.') }}
                        </p>
                    </div>
                    @endif
                    <form method="POST" action="{{ route('admin.shop.woocommerce.register') }}">
                        @csrf
                        <div class="mb-3">
                            <label for="woo_url" class="form-label">{{ __('Website Url') }}</label>
                            <input dir="ltr" type="url" class="form-control" id="woo_url" name="woo_url"
                                placeholder="https://example.com" value="{{ auth()->user()->shop->woo_url }}" required>
                            @error('woo_url')
                            <small class="text-danger"> {{ $message }} </small>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="consumer_key" class="form-label">Consumer Key</label>
                            <input dir="ltr" type="text" class="form-control" id="consumer_key" name="consumer_key"
                                placeholder="ck_xxxxxxxxxxxxxxxxxxxxxxxxx" value="{{ auth()->user()->shop->consumer_key != null ? decrypt(auth()->user()->shop->consumer_key) : '' }}" required>
                            @error('consumer_key')
                            <small class="text-danger"> {{ $message }}</small>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="consumer_secret" class="form-label">Consumer Secret</label>
                            <input dir="ltr" type="text" class="form-control" id="consumer_secret" name="consumer_secret"
                                placeholder="cs_xxxxxxxxxxxxxxxxxxxxxxxxx" value="{{ auth()->user()->shop->consumer_secret != null ? decrypt(auth()->user()->shop->consumer_secret) : ''  }}" required>
                            @error('consumer_secret')
                            <small class="text-danger"> {{ $message }}</small>
                            @enderror
                        </div>

                        <div class="d-flex justify-content-end mt-4">
                            <button type="submit" class="btn btn-primary px-5">
                                {{ __('connect') }}
                            </button>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
