@extends('layouts.blesser.app')

@section('content')
<div class="container pb-28 pt-6 lg:pb-10">
    <!--  Breadcrumb -->
    <div class="mb-2 rounded-lg bg-muted shadow lg:mb-6">
        <ol class="relative grid grid-cols-3 overflow-hidden rounded-lg">
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-shopping-cart h-6 w-6 md:h-8 md:w-8"></div>
                <p class="leading-none">سبد خرید</p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary sm:text-sm md:text-base">
                <div class="i-lucide-clipboard-pen-line h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none">شیوه ارسال</p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-credit-card h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none">پرداخت</p>
            </li>
            <!--  for position set value 0 , 33.33% , 66.66%  -->
            <div class="absolute bottom-0 z-0 h-full w-1/3 touch-none bg-primary/10 transition-all duration-300" style="inset-inline-start: 33.33%"></div>
        </ol>
    </div>
    <!-- Content -->
    <div class="grid grid-cols-12 gap-2  ">
        <div class="col-span-12 ">
            <div class="rounded-lg bg-muted p-4 shadow mb-3">
                <livewire:user.address-tab :selection="true" />

            </div>
            <div class="hidden rounded-lg bg-muted p-4 shadow lg:block">
                <div>
                    <a href="{{ route('cart.checkout') }}" class="inline-flex h-11 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-primary-btn px-8 text-sm font-medium text-white ring-offset-background transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        {{ __('Checkout') }}
                    </a>
                </div>
            </div>
            <div class="fixed inset-x-0 bottom-0 z-20 rounded-t-xl bg-muted px-4 pb-20 pt-4 transition-all duration-300 lg:hidden" data-onscrollclass="translate-y-1/2">
                <div>
                    <a href="{{ route('cart.checkout') }}" class="inline-flex h-10 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-primary-btn px-4 py-2 text-sm font-medium text-white ring-offset-background transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        {{ __('Checkout') }}
                    </a>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
