@extends('layouts.blesser.app')

@section('content')
<div class="relative">

    <div class="pointer-events-none absolute inset-0 flex items-center justify-center overflow-hidden [mask-image:radial-gradient(transparent_15%,white)]">
        <svg class="absolute left-0 top-0 h-full w-full stroke-black/20 stroke-[2] [mask-image:linear-gradient(transparent_5%,white,transparent_85%)] dark:stroke-white/20" data-n-ids="{&quot;1a4MN34vH0:0&quot;:&quot;1a4MN34vH0:0&quot;}">
            <rect width="100%" height="100%" stroke-width="0" fill="url(#grid-pattern-1a4MN34vH0:0)"></rect>
            <svg>
                <rect stroke-width="0" width="95" height="95" x="97" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="385" y="193" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="193" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="673" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="481" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="577" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1441" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1057" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="961" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                <rect stroke-width="0" width="95" height="95" x="1249" y="577" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
            </svg>
            <defs>
                <pattern id="grid-pattern-1a4MN34vH0:0" viewBox="0 0 64 64" width="96" height="96" patternUnits="userSpaceOnUse">
                    <path d="M64 0H0V64" fill="none"></path>
                </pattern>
            </defs>
        </svg>
    </div>

    <div class="container relative pt-10">

        <div class=" rounded-lg bg-muted px-4 py-6 ">
            <h1 class="text-2xl mb-2 flex justify-between align-middle">
                <p>
                    {{ $question->title }}
                    <span class="text-sm ">
                        {{ $question->category->name }}
                    </span>
                </p>
                <p>
                    ({{ $question->answers->count() }}) {{ __('answers') }}
                </p>
            </h1>
            <hr>
            <p class="p-3 whitespace-pre-line">
                {{ $question->body }}
            </p>
        </div>

        @forelse ($answers as $answer )
        <div class="relative rounded-lg bg-muted px-4 py-6 my-6">
            <div class="border-s-1 border-white ps-3">
                <div class="flex items-center gap-2 mb-2">
                    <div class="size-8 ">
                        <img src="/assets/themes/blesser/images/user.png" alt=" علیرضا هادی زاده">
                    </div>
                    {{ $answer->user->name }}:
                </div>
                <!-- body -->
                <p class="whitespace-pre-line">
                    {{ $answer->body }}
                </p>
                <!-- footer -->
                <div class="flex justify-between">
                    <p></p>
                    <p>{{ $answer->created_at->diffForHumans() }}</p>
                </div>
            </div>

            <div class="absolute left-[10px] top-0 ">
                <form action="{{ route('faq.questions.answers.vote') }}" method="post">
                    <input type="hidden" name="answer_id" value="{{ $answer->id }}">
                    <input type="hidden" name="question_id" value="{{ $question->id }}">
                    @csrf
                    <div class="flex flex-col mt-4 items-center">
                        <button name="vote" value="up">
                            <svg aria-hidden="true" class="svg-icon iconArrowUp cursor-pointer" width="28" height="28" viewBox="0 0 18 18">
                                <path d="M1 12h16L9 4z"></path>
                            </svg>
                        </button>
                        <span>
                            {{ $answer->vote_score }}
                        </span>
                        <button name="vote" value="down">
                            <svg aria-hidden="true" class="svg-icon iconArrowDown cursor-pointer" width="28" height="28" viewBox="0 0 18 18">
                                <path d="M1 6h16l-8 8z"></path>
                            </svg>
                        </button>
                    </div>
                </form>
            </div>

            @auth
            <div class="py-3" x-data="{ showComment: false , showFlag: false }">
                <div class="py-3 flex justify-end">
                    @if (auth()->check() && $question->user_id == auth()->user()->id)
                    <div class="py-3">
                        <form action="{{ route('faq.questions.answers.best' , ['question' => $question->id , 'answer' => $answer->id]) }}" method="post">
                            @csrf
                            <div class="flex justify-between">
                                <p></p>
                                <button type="submit" class="text-success  px-4 py-2 cursor-pointer flex items-center gap-2">
                                    <span class="i-lucide-square-check-big "></span>
                                    {{ $question->best_answer_id == $answer->id ? __('Unmark as best answer') : __('Mark as best answer') }}
                                </button>
                            </div>
                        </form>
                    </div>
                    @endif
                    <button @click="showComment = !showComment; showFlag = false" class="text-primary  px-4 py-2 cursor-pointer  flex items-center gap-2">
                        <span class="i-lucide-message-square-text "></span>
                        {{ __('Submit Comment') }}
                    </button>
                    <button @click="showFlag = !showFlag; showComment = false" class="text-warning  px-4 py-2 cursor-pointer flex items-center gap-2">
                        <span class="i-lucide-flag "></span>
                        {{ __('report') }}
                    </button>
                </div>
                <form x-show="showFlag" action="{{ route('faq.questions.answers.flag.store' , ['question' => $question->id , 'answer' => $answer->id]) }}" method="post">
                    @csrf
                    <div class="">
                        <div class="">
                            <x-blesser.ui.form.textarea name="reason" label="{{ __('report message') }}" rows="4" placeholder="{{ __('Write your report here...') }}" />
                            @error('body')
                            <small class="text-small text-red-600">{{ $message }}</small>
                            @enderror
                        </div>
                        <button type="submit" class="btn-primary rounded-lg px-4 py-2 cursor-pointer">
                            {{ __('Submit Report') }}
                        </button>
                    </div>
                </form>
                <form x-show="showComment" action="{{ route('faq.questions.answers.comment.store' , ['question' => $question->id , 'answer' => $answer->id]) }}" method="post">
                    @csrf
                    <div class="">
                        <div class="">
                            <x-blesser.ui.form.textarea name="body" label="{{ __('Answer') }}" rows="4" placeholder="{{ __('Write your answer here...') }}" />
                            @error('body')
                            <small class="text-small text-red-600">{{ $message }}</small>
                            @enderror
                        </div>
                        <button type="submit" class="btn-primary rounded-lg px-4 py-2 cursor-pointer">
                            {{ __('Submit Comment') }}
                        </button>
                    </div>
                </form>
            </div>
            @endauth

            @foreach ($answer->comments as $comment )
            <div class="border-s-1 border-white ps-3 mr-10">
                <div class="flex items-center gap-2 mb-2">
                    <div class="size-8 ">
                        <img src="/assets/themes/blesser/images/user.png" alt=" علیرضا هادی زاده">
                    </div>
                    {{ $comment?->user?->name }}:
                </div>
                <!-- body -->
                <p class="whitespace-pre-line">
                    {{ $comment->body }}
                </p>
                <!-- footer -->
                <div class="flex justify-between">
                    <p></p>
                    <p>{{ $comment->created_at->diffForHumans() }}</p>
                </div>
            </div>
            @endforeach
        </div>
        @empty
        <div class="relative rounded-lg bg-muted px-4 py-6 my-6">
            {{ __('Not Found') }}
        </div>
        @endforelse

        {{ $answers->links('pagination.blesser') }}
        @auth

        <div class=" rounded-lg bg-muted px-4 py-6 my-6 ">

            <h3 class="text-xl mb-2">
                {{ __('submit your answer') }}
            </h3>
            <hr>
            @session('success')
            <div class="p-3">
                <x-blesser.ui.alert type="" class="mb-4">{{ session('success') }}</x-blesser.ui.alert>
            </div>
            @endsession

            <form action="{{ route('faq.questions.answers.store' , $question->id) }}" method="post">
                @csrf

                <div class="">
                    <x-blesser.ui.form.textarea name="body" label="{{ __('Answer') }}" rows="4" placeholder="{{ __('Write your answer here...') }}" />
                    @error('body')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="flex items-center justify-end gap-4">
                    <button class="btn-primary rounded-lg px-4 py-2">
                        {{ __('submit') }}
                    </button>
                </div>

            </form>
        </div>
        @endauth
    </div>

</div>
@endsection
