@extends('layouts.blesser.app')


@section('content')
<div class="container pt-20 ">
    <h1 class="mb-4 text-5xl font-bold text-text text-center">
        {{ __('Request a Shop Account') }}
        <br>
        <span class="text-xl text-text/80">
            {{ __('Create your own shop and start selling!') }}
        </span>
    </h1>
    <div class="rounded-lg bg-muted px-4 py-6 mb-3">
        <form action="{{ route('user.shop.store') }}" method="post" enctype="multipart/form-data">
            @csrf
            <div class=" rounded-lg bg-muted px-4 py-6">
                @session('error')
                <div class="p-3">
                    <x-blesser.ui.alert type="error" class="mb-4">{{ session('error') }}</x-blesser.ui.alert>
                </div>
                @endsession
                @session('success')
                <div class="p-3">
                    <x-blesser.ui.alert type="success" class="mb-4">{{ session('success') }}</x-blesser.ui.alert>
                </div>
                @endsession

                <div class="mb-3">
                    <x-blesser.ui.form.input name="name" label="{{ __('Shop Name') }}" placeholder="{{ __('Enter shop name') }}" :value="old('name',auth()->user()->shop->name ?? '')" />
                    @error('name')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="mb-3">
                    <x-blesser.ui.form.input type="file" name="logo" label="{{ __('Shop Logo') }}" />
                    @error('logo')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="mb-3">
                    <x-blesser.ui.form.textarea name="description" label="{{ __('Shop Description') }}" rows="4" placeholder="{{ __('Write a description for your shop...') }}">{{ old('description' ,auth()->user()->shop->description ?? '') }}</x-blesser.ui.form.textarea>
                    @error('description')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="mb-3">
                    <x-blesser.ui.form.input name="phone" label="{{ __('Phone Number') }}" placeholder="{{ __('Enter shop phone number') }}" :value="old('phone' , auth()->user()->shop->phone ?? '')" />
                    @error('phone')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="mb-3">
                    <x-blesser.ui.form.input type="email" name="email" label="{{ __('Shop Email') }}" placeholder="{{ __('Enter shop email address') }}" :value="old('email' ,auth()->user()->shop->email ?? '')" />
                    @error('email')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="mb-3">
                    <x-blesser.ui.form.textarea name="address" label="{{ __('Address') }}" rows="3" placeholder="{{ __('Enter shop address') }}">{{ old('address' ,auth()->user()->shop->address ?? '') }} </x-blesser.ui.form.textarea>
                    @error('address')
                    <small class="text-small text-red-600">{{ $message }}</small>
                    @enderror
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-3">
                    <div>
                        <x-blesser.ui.form.input name="city" label="{{ __('City') }}" placeholder="{{ __('Enter city') }}" :value="old('city' , auth()->user()->shop->city?? '')" />
                        @error('city')
                        <small class="text-small text-red-600">{{ $message }}</small>
                        @enderror
                    </div>
                    <div>
                        <x-blesser.ui.form.input name="state" label="{{ __('State / Province') }}" placeholder="{{ __('Enter state or province') }}" :value="old('state', auth()->user()->shop->state ?? '')" />
                        @error('state')
                        <small class="text-small text-red-600">{{ $message }}</small>
                        @enderror
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-3">
                    <div>
                        <x-blesser.ui.form.input name="postal_code" label="{{ __('Postal Code') }}" placeholder="{{ __('Enter postal code') }}" :value="old('postal_code', auth()->user()->shop->postal_code ?? '')" />
                        @error('postal_code')
                        <small class="text-small text-red-600">{{ $message }}</small>
                        @enderror
                    </div>
                    <div>
                        <x-blesser.ui.form.input name="country" label="{{ __('Country') }}" placeholder="{{ __('Enter country') }}" :value="old('country', auth()->user()->shop->country ?? '')" />
                        @error('country')
                        <small class="text-small text-red-600">{{ $message }}</small>
                        @enderror
                    </div>
                </div>

                <div class="flex items-center justify-end gap-4">
                    @if (auth()->user()->hasShop())
                    <div class="flex items-center gap-2">
                        @if (auth()->user()->shopIsApproved())
                        <span class="text-success mt-3 text-bold">
                            {{ __('Your shop account is approved') }}
                        </span>
                        @else
                        <span class="text-warning mt-3 text-bold">
                            {{ __('Your shop account is under review') }}
                        </span>
                        @endif
                    </div>
                    @else
                    <button type="submit" class="btn-primary rounded-lg px-4 py-2">
                        {{ __('Request Shop Account') }}
                    </button>
                    @endif
                </div>
            </div>
        </form>
    </div>
</div>

@endsection
