@extends('layouts.syndron.app')

<?php

$menuItems = [
    [
        'url' => route('admin.loyalty.referrals.index'),
        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" width="60" height="60" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"> <!-- Inner circle -->
    <circle cx="50" cy="50" r="30" /> <!-- Five‑point star -->
    <path d="M 50.00,30.00L 54.70,43.53L 69.02,43.82L 57.61,52.47L 61.76,66.18L 50.00,58.00L 38.24,66.18L 42.39,52.47L 30.98,43.82L 45.30,43.53 Z " /> <!-- Top‑right outer arc -->
    <path d="M84.64,30.00 A40,40 0 0,1 70.00,84.64" /> <!-- Bottom‑left outer arc -->
    <path d="M15.36,70.00 A40,40 0 0,1 30.00,15.36" />
</svg>',
        'title' => __('Referrals'),
        'description' => __('Overview of your data'),
        'badge' => __('New'),
    ],
    [
        'url' => route('admin.loyalty.tiers.index'),
        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" width="60" height="60" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"> <!-- Inner circle -->
    <circle cx="50" cy="50" r="30" /> <!-- Five‑point star -->
    <path d="M 50.00,30.00L 54.70,43.53L 69.02,43.82L 57.61,52.47L 61.76,66.18L 50.00,58.00L 38.24,66.18L 42.39,52.47L 30.98,43.82L 45.30,43.53 Z " /> <!-- Top‑right outer arc -->
    <path d="M84.64,30.00 A40,40 0 0,1 70.00,84.64" /> <!-- Bottom‑left outer arc -->
    <path d="M15.36,70.00 A40,40 0 0,1 30.00,15.36" />
</svg>',
        'title' => __('Tiers'),
        'description' => __('Manage your loyalty tiers'),
        'badge' => __('New'),
    ],
    [
        'url' => route('admin.loyalty.settings.edit'),
        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" width="60" height="60" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"> <!-- Inner circle -->
    <circle cx="50" cy="50" r="30" /> <!-- Five‑point star -->
    <path d="M 50.00,30.00L 54.70,43.53L 69.02,43.82L 57.61,52.47L 61.76,66.18L 50.00,58.00L 38.24,66.18L 42.39,52.47L 30.98,43.82L 45.30,43.53 Z " /> <!-- Top‑right outer arc -->
    <path d="M84.64,30.00 A40,40 0 0,1 70.00,84.64" /> <!-- Bottom‑left outer arc -->
    <path d="M15.36,70.00 A40,40 0 0,1 30.00,15.36" />
</svg>',
        'title' => __('Settings'),
        'description' => __('Manage your loyalty settings'),
        'badge' => __('New'),
    ],
    // …
];

?>
@section('content')

<div class="alert alert-info">
این بخش در جدید و در حال توسعه می باشد و فقط در بخش ادمین اضافه شده است و مشتریان دسترسی برای مشاهده و تغییر ندارند
</div>


<div class="d-flex align-items-center justify-content-between mb-3">
    <div>
        <form id="generateReferralCodesForm" action="{{ route('admin.loyalty.generate-referral-codes') }}" method="post">
            @csrf
            <div>
                <button class=" btn btn-primary" type="button" onclick="loading(); document.getElementById('generateReferralCodesForm').submit();">
                    {{ __('Generate Referral Codes') }}
                </button>
            </div>
        </form>
    </div>
</div>
<div>
    <x-ui.grid-menu :items="$menuItems" />
</div>


@endsection
