@extends('layouts.syndron.app')


@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('Referrals') }}</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="referrals-table" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>{{ __('ID') }}</th>
                                <th>{{ __('Referrer ') }}</th>
                                <th>{{ __('Referee ') }}</th>
                                <th>{{ __('Bonus Awarded') }}</th>
                                <th>{{ __('Date') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($referrals as $referral)
                            <tr>
                                <td>{{ $referral->id }}</td>
                                <td> {{ $referral->referrer->name ?? $referral->referrer->phone ?? '' }} ({{ $referral->referrer_id }})</td>
                                <td> {{ $referral->referee->name ?? $referral->referee->phone ?? '' }} ({{ $referral->referee_id }})</td>
                                <td>{{ $referral->bonus_awarded }}</td>
                                <td>{{ verta($referral->created_at)->format('Y-m-d H:i') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
    </div>
    <!-- /.row -->
</div>

@endsection

@push('scripts')
<script>
    $(function() {
        $("#referrals-table").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
        });
    });
</script>
@endpush
