<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Actions\Admin\Shop\SailOverviewAction;
use App\Http\Actions\Admin\Shop\AcceptedQuoteAction;
use App\Http\Actions\Admin\Shop\ShopDashboardAction;
use App\Http\Controllers\InventoryVariantController;
use App\Http\Actions\Admin\Shop\RegisterWooCommerceShop;
use App\Http\Controllers\Admin\Shop\InventoryController;
use App\Http\Controllers\Admin\WooCommerce\WooOrderController;
use App\Http\Controllers\Admin\WooCommerce\WooProductController;
use App\Http\Controllers\Admin\WooCommerce\WooCustomerController;

Route::prefix('shop')->name('shop.')->middleware(['module:multi-shop-seller'])->group(function () {
    Route::get('/up', function () {
        return 'admin shop route group is active';
    });

    Route::get('dashboard', ShopDashboardAction::class)->name('dashboard');
    Route::get('overview/sale', SailOverviewAction::class)->name('overview.sale');
    Route::get('admin.shop.setting', ShopDashboardAction::class)->name('setting');

    Route::get('select-product', [ProductController::class, 'index'])->name('product-selection');

    Route::get('add/inventory/{product}', [ProductController::class, 'show'])->name('add.inventory');

    Route::resource('inventory', InventoryController::class);
    Route::resource('inventory.variant', InventoryVariantController::class);

    Route::prefix('woocommerce')->name('woocommerce.')->middleware('module:woocommerce-sync')->group(function () {

        Route::view('register', 'pages.admin.woocommerce.register')->name('register');
        Route::post('register', RegisterWooCommerceShop::class);

        Route::prefix('product')->name('product.')->group(function () {
            Route::get('list', [WooProductController::class, 'list'])->name('list');
        });
        Route::prefix('order')->name('order.')->group(function () {
            Route::get('list', [WooOrderController::class, 'list'])->name('list');
        });
        Route::prefix('customer')->name('customer.')->group(function () {
            Route::get('list', [WooCustomerController::class, 'list'])->name('list');
        });
    });



    Route::get('pre-invoice/accepted-quote', AcceptedQuoteAction::class)->name('pre-invoice.accepted-quote');
});
