<!-- Story modal -->
<div id="story-modal" tabindex="-1" aria-hidden="true" class="fixed left-0 right-0 top-0 z-50 hidden h-full max-h-full w-full overflow-y-auto p-4 md:inset-0">
    <?php if(false): ?>
    <div class="lg:w-90 relative max-h-full w-full max-w-sm">
        <div class="overflow-hidden rounded-lg">
            <div data-story class="relative w-full [border-image:fill_0_linear-gradient(#0003,#000)]">
                <div class="absolute inset-x-0 top-0 z-10 flex h-16 items-center rounded-b-lg px-4">
                    <div class="flex w-full items-center justify-between gap-4">
                        <div class="flex items-center gap-4">
                            <!-- Close -->
                            <button data-modal-hide="story-modal" type="button">
                                <span class="i-lucide-arrow-right size-7 stroke-2 text-white"></span>
                            </button>
                            <!-- Author -->
                            <a href="#" class="flex items-center gap-2">
                                <img src="/assets/themes/blesser/images/user.png" alt="story author" class="size-10 rounded-full" />
                                <p class="truncate font-medium text-white">TaymaZ</p>
                            </a>
                        </div>
                        <button class="h-10 rounded-lg bg-white px-4 text-sm text-black">دنبال کن</button>
                    </div>
                </div>
                <!-- Muted -->
                <div data-toggle-mute class="absolute inset-0 flex items-center justify-center">
                    <div class="i-solar-muted-linear size-20 text-white"></div>
                </div>
                <div>
                    <video data-video class="lazy-story object-cover" src="/assets/themes/blesser/images/story.mp4" muted autoplay playsinline loop preload="auto"></video>
                </div>
                <div class="absolute inset-x-0 bottom-0 z-10 p-4">
                    <div class="mb-6 flex items-end justify-between gap-20">
                        <!-- Title -->
                        <div class="line-clamp-2 text-lg font-medium text-white">تیکا ؛ تست حافظه! تیکا ؛ تست حافظه!</div>
                        <!-- Like, Comment -->
                        <div class="space-y-6">
                            <button class="flex flex-col items-center justify-center gap-2 text-sm text-white">
                                <span class="i-lucide-heart size-6"></span>
                                76
                            </button>
                        </div>
                    </div>
                    <!-- Controls -->
                    <div class="flex items-center justify-between gap-6">
                        <div class="w-full grow">
                            <div data-bar></div>
                        </div>
                        <!-- Time -->
                        <p data-time class="w-6 text-sm text-white"></p>
                    </div>
                </div>
            </div>

            <div class="h-24 bg-background p-2">
                <div class="swiper story-product-slider h-full">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <a href="./product-detail.html" class="flex h-full items-center gap-4 rounded-lg bg-muted p-2">
                                <img src="/assets/themes/blesser/images/p6.webp" alt="story product" class="size-16 rounded-full" />
                                <p class="line-clamp-2 text-sm text-text/80">کفش سالومون اکس تی راش Salomon XT-RUSH</p>
                            </a>
                        </div>
                        <div class="swiper-slide">
                            <a href="./product-detail.html" class="flex h-full items-center gap-4 rounded-lg bg-muted p-2">
                                <img src="/assets/themes/blesser/images/p6.webp" alt="story product" class="size-16 rounded-full" />
                                <p class="line-clamp-2 text-sm text-text/80">کفش سالومون اکس تی راش Salomon XT-RUSH</p>
                            </a>
                        </div>
                        <div class="swiper-slide">
                            <a href="./product-detail.html" class="flex h-full items-center gap-4 rounded-lg bg-muted p-2">
                                <img src="/assets/themes/blesser/images/p6.webp" alt="story product" class="size-16 rounded-full" />
                                <p class="line-clamp-2 text-sm text-text/80">کفش سالومون اکس تی راش Salomon XT-RUSH</p>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/layouts/blesser/modal.blade.php ENDPATH**/ ?>