<div class="z-10 w-full py-10 xs:container">
    <div class="relative mx-auto bg-muted px-4 py-8 xs:max-w-[440px] xs:rounded-xl lg:px-10 lg:py-12">
        <form class="flex flex-col">
            <!-- logo -->
            <a href="<?php echo e(route('home')); ?>" class="mb-10">
                <img src="<?php echo e(asset('uploads/'.getSiteLogo())); ?>" alt="logo" class="mx-auto h-10 xs:h-12" />
            </a>

            <h1 class="mb-8 text-center font-medium xs:text-lg">
                <?php echo e(__("Login or Register")); ?>

            </h1>

            <!-- username -->
            <div class="mb-4 w-full space-y-3">
                <label for="username" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="identifier" wire:keydown.prevent.enter="handel" dir="ltr" type="text" id="username" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
                        <?php echo e(__('Email or your phone number')); ?>

                    </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['identifier'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </p>
            </div>

            <button type="button" wire:click="handel" wire:loading.attr="disabled" wire:target="handel" class="btn-primary py-3">
                <?php echo e(__('Login')); ?>


                <div wire:loading class="i-lucide-loader-circle animate-spin"></div>
            </button>
            <!-- rules -->
            <p class="mt-5 text-center text-sm text-text/80">
                <?php echo e(__('Registration and login mean acceptance of the store\'s terms of use and privacy policies.')); ?>

                <!-- <a href="#" class="text-primary duration-200 hover:text-primary/80"><?php echo e(__('rules')); ?>.</a> -->
            </p>
        </form>
    </div>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/livewire/auth/login-identifier.blade.php ENDPATH**/ ?>