<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['product']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['product']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>
<div class="<?php echo e($attributes->get('class')); ?> border-gradient relative rounded-[--product-card-radius] p-px [--product-card-radius:theme(borderRadius.2xl)] before:absolute before:-inset-px before:h-[calc(100%+2px)] before:w-[calc(100%+2px)] before:rounded-[var(--product-card-radius)] before:content-['']">
    <a href="<?php echo e(route('product.details' , $product->slug)); ?>" class="relative block overflow-hidden rounded-[calc(var(--product-card-radius)-1px)] bg-muted">
        <div class="mb-4 bg-secondary p-2 lg:p-4">
            <!-- Special Sale Percentage  -->
            <?php if(!is_null($product->off_rate) && $product->off_rate != 0): ?>
            <div class="absolute right-2 top-0 rounded-b-full bg-warning px-1 py-1.5 text-center text-sm font-medium text-white md:text-base">
                %<?php echo e($product->off_rate); ?>

            </div>
            <?php endif; ?>
            <!-- Image -->
            <img src="<?php echo e($product->brand_img); ?>" alt=" Blesser" class="aspect-[1/1] w-full rounded-xl object-cover" />
        </div>
        <div class="mb-1 px-2 lg:px-4">
            <p class="line-clamp-2 h-10 text-sm xs:h-12 xs:text-base">
                <?php echo e($product->title); ?>

            </p>
            <?php if($product->isInStock()): ?>
            <div class="gap-x-1 text-end font-bold text-primary mb-1 px-2 lg:px-4 ">
                <?php if($product->discount_price != 0 && $product->discount_price != null): ?>
                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                    <del>
                        <?php echo e(number_format($product->price)); ?> <?php echo e(getCurrency()); ?>

                    </del>
                </div>
                <span class="text-sm xs:text-base"><?php echo e(number_format($product->discount_price)); ?></span>
                <span class="text-sm font-light"><?php echo e(getCurrency()); ?></span>
                <?php else: ?>
                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                </div>
                <span class="text-sm xs:text-base"><?php echo e($product->display_price); ?></span>
                <span class="text-sm font-light"><?php echo e($product->price != 0 ? getCurrency() : ''); ?></span>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div class="gap-x-1 text-end font-bold text-red-500 mb-1 px-2 lg:px-4 ">
                <div class="h-5 text-end text-sm text-text/50 xs:text-base">
                </div>
                <span class=""><?php echo e(__('Out of stock')); ?></span>
            </div>
            <?php endif; ?>

        </div>
        <?php if(false): ?>
        <div class="h-8 px-2 lg:px-4">
            <!-- Countdown -->

            <div class="product-special-timer text-end text-sm text-warning" dir="ltr" data-expire-date="2024-12-01T00:00:00"></div>

            <!-- Proccess Bar -->
            <div class="h-1 w-full rounded-full bg-secondary" dir="ltr">
                <div class="progress-bar h-1 rounded-full bg-warning transition-all duration-1000" data-start-date="2024-05-01T00:00:00" data-expire-date="2024-12-01T00:00:00"></div>
            </div>
        </div>
        <?php endif; ?>
    </a>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/element/single-product-card.blade.php ENDPATH**/ ?>