<?php $__env->startSection('content'); ?>

<div class="container pb-28 pt-6 lg:pb-10">
    <!--  Breadcrumb -->
    <div class="mb-2 rounded-lg bg-muted shadow lg:mb-6">
        <ol class="relative grid grid-cols-3 overflow-hidden rounded-lg">
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary sm:text-sm md:text-base">
                <div class="i-lucide-shopping-cart h-6 w-6 md:h-8 md:w-8"></div>
                <p class="leading-none"><?php echo e(__('cart')); ?></p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-clipboard-pen-line h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none"><?php echo e(__('delivery')); ?></p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-credit-card h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none"><?php echo e(__('payment')); ?></p>
            </li>
            <!--  for position set value 0 , 33.33% , 66.66%  -->
            <div class="absolute bottom-0 z-0 h-full w-1/3 touch-none bg-primary/10 transition-all duration-300" style="inset-inline-start: 0"></div>
        </ol>
    </div>
    <!-- Content -->
    <div class="grid grid-cols-12 gap-2 lg:gap-6">
        <div class="col-span-12 lg:col-span-8">
            <div class="rounded-lg bg-muted shadow">
                <div class="flex items-center justify-between gap-2 p-4">
                    <h1 class="flex items-center gap-x-4 text-sm xs:text-base md:text-lg">
                        <?php echo e(__('shopping cart')); ?>

                        <span class="text-sm text-text/60"> ( <?php echo e($cart !== null ? $cart->count() : 0); ?> <?php echo e(__("items")); ?> ) </span>
                    </h1>
                    <form action="<?php echo e(route('cart.clear')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button class="inline-flex h-9 items-center justify-center gap-x-2 whitespace-nowrap rounded-md px-3 text-sm font-medium text-warning ring-offset-background transition-colors hover:text-warning/70 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50" type="submit">
                            <div class="i-lucide-trash-2 h-5 w-5"></div>
                            <span>
                                <?php echo e(__('clear cart')); ?>

                            </span>
                        </button>
                    </form>
                </div>
                <?php if($items == null): ?>
                <div class="flex items-center justify-center py-10">
                    <div class="flex flex-col items-center justify-center gap-4">
                        <div class="i-lucide-package-x w-12 h-12"></div>
                        <div>
                            <?php echo e(__('your cart is empty')); ?>

                        </div>
                    </div>
                </div>
                <?php else: ?>
                <ul class="divide-y">
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <div class="px-4 py-4 sm:py-6">
                            <div class="grid grid-cols-2 items-center justify-start gap-2 xs:grid-cols-3 xs:gap-6 sm:grid-cols-4 xl:grid-cols-6">
                                <div class="relative row-span-2 min-w-fit xs:mx-auto">
                                    <a href="<?php echo e(route('product.details', $item->product->slug)); ?>">
                                        <img src="<?php echo e($item->product->brand_img); ?>" alt="<?php echo e($item->product->title); ?>" class="h-25 w-25 rounded-lg object-cover sm:h-28 sm:w-28">
                                    </a>
                                    <form action="<?php echo e(route('cart.remove')); ?>" method="POST" class="absolute -top-2 right-0">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="product_id" value="<?php echo e($item->product->id); ?>">
                                        <input type="hidden" name="inventory_id" value="<?php echo e($item->inventory_id); ?>">
                                        <input type="hidden" name="variant" value="<?php echo e($item->variant_id); ?>">
                                        <input type="hidden" name="shop_id" value="<?php echo e($item->shop_id); ?>">
                                        <button type="submit" class="rounded-lg border bg-muted duration-200 hover:bg-background p-2">
                                            <div class="i-lucide-trash m-0 h-5 w-5 text-warning"></div>
                                        </button>
                                    </form>
                                </div>
                                <div class="row-span-2 space-y-4 xs:col-span-2 sm:col-span-3 xl:col-span-5">
                                    <a href="<?php echo e(route('product.details', $item->product->slug)); ?>" class="line-clamp-2 text-sm xs:text-base"><?php echo e($item->product->title); ?></a>
                                    <div class="space-y-2 text-text/95">
                                        <?php if(!empty($item->variant)): ?>
                                        <?php $__currentLoopData = json_decode($item->variant); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-center gap-2">
                                            <div><?php echo e(ucfirst($key)); ?></div>
                                            <div>
                                                <?php if(is_string($value) && Str::startsWith($value, '#')): ?>
                                                <div class="h-6 w-6 rounded-full border-2" style="background-color: <?php echo $value ?>"></div>
                                                <?php else: ?>
                                                <div><?php echo e($value); ?></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                    </div>
                                </div>
                                <div class="flex items-center gap-x-2 xs:justify-center">
                                    <form action="<?php echo e(route('cart.update')); ?>" method="POST" class="flex items-center">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="product_id" value="<?php echo e($item->product->id); ?>">
                                        <input type="hidden" name="inventory_id" value="<?php echo e($item->inventory_id); ?>">
                                        <input type="hidden" name="shop_id" value="<?php echo e($item->shop_id); ?>">
                                        <div class="flex h-10 w-24 items-center justify-between rounded-lg border px-2 py-1">
                                            <button name="quantity" value="<?php echo e($item->quantity + 1); ?>" type="submit" class="text-success disabled:text-text/60">
                                                <div class="i-lucide-plus size-6"></div>
                                            </button>
                                            <div class="flex h-5 w-full grow select-none items-center justify-center bg-transparent text-center text-sm text-text outline-none">
                                                <?php echo e($item->quantity); ?>

                                            </div>
                                            <button name="quantity" value="<?php echo e($item->quantity - 1); ?>" type="submit" class="text-warning disabled:text-text/60">
                                                <div class="i-lucide-minus size-6"></div>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="flex items-center gap-2 text-primary xs:col-span-2 sm:col-span-3 lg:text-lg xl:col-span-5">
                                    <span class="font-bold"><?php echo e(number_format($item->price * $item->quantity)); ?></span><span class="text-sm lg:text-base">
                                        <?php echo e(getCurrency()); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <?php endif; ?>
            </div>
        </div>
        <div class="lg:col-span-4">
            <div class="hidden rounded-lg bg-muted p-4 shadow lg:block">
                <div class="mb-2 divide-y">
                    <div class="flex items-center justify-between gap-x-2 py-6">
                        <div class="text-sm text-text/95 lg:text-base">
                            <?php echo e(__('total price')); ?>

                            (<?php echo e($cart !== null ? $cart->count() : 0); ?>)
                        </div>
                        <div class="flex items-center gap-1 text-sm lg:text-base">
                            <div class="font-bold"><?php echo e($cart !== null ? number_format($cart->subtotal) : 0); ?></div>
                            <div class="text-xs lg:text-sm">
                                <?php echo e(getCurrency()); ?>

                            </div>
                        </div>
                    </div>
                    <div class="flex items-center justify-between gap-x-2 py-6">
                        <div class="text-sm text-text/95 lg:text-base">
                            <?php echo e(__('discount')); ?>

                        </div>
                        <div class="flex items-center gap-1 text-sm font-medium text-warning lg:text-base">
                            <div class="font-bold"><?php echo e($cart !== null ? number_format($cart->discount_total) : 0); ?></div>
                            <div class="text-xs lg:text-sm">تومان</div>
                        </div>
                    </div>
                    <div class="flex items-center justify-between gap-x-2 py-6">
                        <div class="text-sm text-text/95 lg:text-base">
                            <?php echo e(__('total price after discount')); ?>

                        </div>
                        <div class="flex items-center gap-1 text-sm text-primary lg:text-base">
                            <div class="font-bold"><?php echo e($cart !== null ? number_format($cart->grand_total) : 0); ?></div>
                            <div class="text-xs lg:text-sm">
                                <?php echo e(getCurrency()); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <a href="<?php echo e(route('cart.delivery-type')); ?>" class="inline-flex h-11 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-primary-btn px-8 text-sm font-medium text-white ring-offset-background transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        <?php echo e(__('continue')); ?>

                    </a>
                </div>
            </div>
            <div class="fixed inset-x-0 bottom-0 z-20 rounded-t-xl bg-muted px-4 pb-20 pt-4 transition-all duration-300 lg:hidden" data-onscrollclass="translate-y-1/2">
                <div>
                    <a href="<?php echo e(route('cart.delivery-type')); ?>" class="inline-flex h-10 w-full items-center justify-center gap-x-2 whitespace-nowrap rounded-md bg-primary-btn px-4 py-2 text-sm font-medium text-white ring-offset-background transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50">
                        <?php echo e(__('continue')); ?>

                        |
                        <?php echo e($cart !== null ? number_format($cart->subtotal) : 0); ?>

                        <span class="text-xs"> <?php echo e(getCurrency()); ?> </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.blesser.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/cart.blade.php ENDPATH**/ ?>