<?php if($products->isNotEmpty()): ?>
<section class="container py-10">
    <div class="rounded-lg border bg-muted px-5 shadow lg:px-3">
        <!-- Title -->
        <div class="mb-8 mt-6 flex items-center justify-center gap-2 font-medium lg:text-lg xl:text-xl">
            <div class="i-uil-fire size-7 stroke-2 text-warning"></div>
            <div><?php echo e($title); ?></div>
        </div>

        <div class="swiper best-sale-hour-slider">
            <div class="swiper-wrapper">
                <?php $__currentLoopData = $products->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="swiper-slide">
                    <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($product['url'] ?? '#'); ?>" class="relative flex items-center gap-2 py-3 after:absolute after:left-0 after:top-full after:h-px after:w-2/3 after:rounded-full after:bg-secondary after:content-['']">
                        <div class="min-w-fit">
                            <img src="<?php echo e($product['image']); ?>" alt="<?php echo e($product['title']); ?>" class="h-22 w-22 rounded-lg aspect-square object-cover" />
                        </div>
                        <p class="line-clamp-2 text-sm 2xl:text-base"><?php echo e($product['title']); ?></p>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="swiper-button-next main-slider-nav-button"></div>
            <div class="swiper-button-prev main-slider-nav-button"></div>
        </div>
    </div>

</section>
<?php endif; ?>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/element/product-slider-list.blade.php ENDPATH**/ ?>