<footer class="mt-14 border-t bg-muted py-10">
    <div class="container">
        <!-- Top Section -->
        <div class="mb-8 grid grid-cols-12 gap-4 border-b pb-10">
            <!-- Right Section -->
            <div class="col-span-12 lg:col-span-8">
                <div class="grid grid-cols-2 justify-items-center gap-y-6 lg:grid-cols-4 lg:justify-items-start">
                    <?php
                    $footerSections = \App\Models\Option::where('env', 'web')
                    ->where('group', 'footer-first-section')
                    ->get()
                    ->keyBy('key'); // turns into associative collection: ['column-1' => Option, 'column-2' => Option, ...]
                    ?>
                    <?php $__currentLoopData = $footerSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $data = is_array($column->data) ? $column->data : json_decode($column->data ?? '{}', true);
                    ?>
                    <?php if($column && isset($data['links'])): ?>
                    <div class="flex flex-col gap-4 text-center lg:text-right">
                        <div class="select-none font-medium"><?php echo e($column->value); ?></div>
                        <ul class="space-y-px">
                            <?php $__currentLoopData = $data['links']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e($link['url']); ?>" class="block py-2 text-sm text-text/60 duration-200 hover:text-primary">
                                    <?php echo e($link['label']); ?>

                                </a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
            <!-- Left Section -->
            <div class="col-span-12 lg:col-span-4">
                <div class="flex h-full items-center justify-center gap-4 lg:justify-end">
                    <div class="relative">
                        <img src="/assets/themes/blesser/images/images (9).avif" class="h-28 w-28 object-cover" alt="Samandehi Logo" />
                        <div class="absolute inset-0 flex items-center justify-center backdrop-blur-sm">
                            <div class="rounded-lg bg-warning px-4 py-2 text-sm text-white">اعتبار ندارد</div>
                        </div>
                    </div>
                    <div class="relative">
                        <img src="/assets/themes/blesser/images/images (10).avif" class="h-28 w-28 object-cover" alt="Samandehi Logo" />
                        <div class="absolute inset-0 flex items-center justify-center backdrop-blur-sm">
                            <div class="rounded-lg bg-warning px-4 py-2 text-sm text-white">اعتبار ندارد</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Bottom Section -->
        <div class="flex flex-col items-center justify-between gap-y-10 md:flex-row">
            <div class="flex flex-col justify-items-center gap-4 text-center">
                <p>تلفن پشتیبانی</p>
                <a href="tel:<?php echo e(options('contact_phone')->first()->value ?? '#'); ?>" class="flex flex-col items-center justify-between gap-4 text-sm md:flex-row">
                    <div class="">
                        <?php echo e(options('contact_phone')->first()->value ?? '021-00000000'); ?>

                    </div>
                    <div class="hidden h-5 w-0.5 bg-secondary lg:block"></div>
                </a>
            </div>

            <div class="flex flex-col items-center justify-center gap-4 text-center lg:text-right">
                <p><?php echo e(getSiteName()); ?> در شبکه های اجتماعی</p>
                <div class="text-text-/70 flex items-center justify-center gap-x-6 text-center">
                    <?php if(isset(options()->groupBy('group')['social'])): ?>
                    <?php $__currentLoopData = options()->groupBy('group')['social']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e($social->value); ?>" title="<?php echo e($social->key); ?>" class="duration-150 hover:text-primary">
                        <i class="bi bi-<?php echo e($social->key); ?> h-5 w-5"></i>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>

            <button id="scrollToTopButton" class="order-first flex items-center gap-x-3 rounded-md border px-3 py-1.5 text-sm duration-200 hover:bg-background md:order-last lg:text-base">
                <p>برگشت به بالا</p>
                <i class="i-carbon-chevron-up h-4 w-4"></i>
            </button>
        </div>
    </div>
</footer>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/layouts/blesser/footer.blade.php ENDPATH**/ ?>