<div class="">
    <h5 class="d-flex justify-content-between">
        <span>
            <i class="bx bx-folder"></i>
            <?php echo e(__('Folders')); ?>

        </span>
        <button wire:click="goBack" class="btn btn-sm btn-outline-primary d-flex align-items-center justify-content-center gap-1">
            <?php echo e(__('Back')); ?>

            <i class="bx bx-chevron-left"></i>
        </button>
    </h5>

    <div class="row mt-3">
        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $directories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $folder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-12 col-lg-4">
            <div class="card shadow-none border radius-15" wire:click="goToDirectory('<?php echo e($folder); ?>')" style="cursor: pointer;">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="font-30 text-primary"><i class="bx bxs-folder"></i></div>
                    </div>
                    <h6 class="mb-0 text-primary"><?php echo e(basename($folder)); ?></h6>
                    <small><?php echo e(count(Storage::disk($disk)->files($folder))); ?>

                        <?php echo e(__('file')); ?>

                    </small>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <div class="table-responsive mt-3">
        <table class="table table-striped table-hover table-sm mb-0">
            <thead>
                <tr>
                    <th><?php echo e(__('Name')); ?></th>
                    <th><?php echo e(__('Size')); ?></th>
                    <th><?php echo e(__('Last Modified')); ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $url = Storage::disk($disk)->url($file);
                $extension = pathinfo($file, PATHINFO_EXTENSION);
                $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif', 'webp']);
                ?>
                <tr>
                    <td>
                        <div class="d-flex align-items-center">
                            <!--[if BLOCK]><![endif]--><?php if($isImage): ?>
                            <img src="<?php echo e($url); ?>" width="40" class="me-2 rounded border square-box" alt="preview">
                            <?php else: ?>
                            <i class="bx bxs-file me-2 font-24 text-secondary"></i>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <div class="font-weight-bold"><?php echo e(basename($file)); ?></div>
                        </div>
                    </td>
                    <td><?php echo e(number_format(Storage::disk($disk)->size($file) / 1024, 2)); ?> KB</td>
                    <td><?php echo e(date('M d, Y', Storage::disk($disk)->lastModified($file))); ?></td>
                    <td>
                        <button class="btn btn-sm btn-outline-primary" onclick="navigator.clipboard.writeText('<?php echo e($url); ?>')">
                            <?php echo e(__('Copy URL')); ?>

                        </button>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </tbody>
        </table>
    </div>
</div>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/livewire/admin/file-manager.blade.php ENDPATH**/ ?>