<!DOCTYPE html>
<html lang="en" dir="rtl" class="">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <!--favicon-->
    <link rel="icon" href="<?php echo e(getSiteLogo()); ?>" type="image/png" />
    <!--plugins-->
    <link href="/assets/themes/syndron/plugins/vectormap/jquery-jvectormap-2.0.2.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <!-- loader-->
    <link href="/assets/themes/syndron/css/pace.min.css" rel="stylesheet" />
    <script src="/assets/themes/syndron/js/pace.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="/assets/themes/syndron/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/assets/themes/syndron/css/bootstrap-extended.css" rel="stylesheet" />
    <!-- <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet" /> -->
    <?php if(auth()->user()->adminLayout() == 'vertical'): ?>
    <link href="/assets/themes/syndron/css/app.css" rel="stylesheet" />
    <link rel="stylesheet" href="/assets/themes/syndron/css/dark-theme.css" />

    <?php elseif(auth()->user()->adminLayout() == 'horizontal'): ?>
    <link href="/assets/themes/syndron/horizontal/css/app.css" rel="stylesheet" />
    <link rel="stylesheet" href="/assets/themes/syndron/horizontal/css/dark-theme.css" />

    <?php endif; ?>
    <link href="/assets/themes/syndron/css/icons.css" rel="stylesheet" />
    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="/assets/themes/syndron/css/semi-dark.css" />
    <link rel="stylesheet" href="/assets/themes/syndron/css/header-colors.css?v=<?php echo e(env('APP_VERSION')); ?>" />
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@latest/dist/css/persian-datepicker.min.css" />

    <style>
        @font-face {
            font-family: 'IRANYekanXFaNum';
            src: url('/assets/themes/syndron/fonts/iranyekan/IRANYekanXFaNum-Light.woff2') format('woff2');
            font-weight: lighter;
            font-style: normal;
        }

        body {
            font-family: 'IRANYekanXFaNum', sans-serif;
        }

        [class^="apexcharts-"],
        [class*=" apexcharts-"] {
            font-family: 'IRANYekanXFaNum', sans-serif !important;
        }

        [x-cloak] {
            display: none !important;
        }

        .shortcut-button {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 6px 12px;
            gap: 8px;
            /* height: 34px; */
            /* width: 112px; */
            border: none;
            border-radius: 20px;
            cursor: pointer;
        }

        .shortcut-label {
            line-height: 15px;
            font-size: 12px;
            color: #000;
            letter-spacing: 1px;
        }

        .shortcut-button:hover {}

        html div.alert.alert-bg-white
        {
            background-color: white;
        }
        html.dark-theme div.alert.alert-bg-white
        {
            background-color: #161515;
        }
    </style>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/admin/app.css' , 'resources/js/admin/app.js']); ?>

    <?php echo $__env->yieldContent('extra-vite'); ?>

    <?php echo $__env->yieldContent('style'); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>

    <title> <?php echo e(getSiteName()); ?> | <?php echo $__env->yieldContent('title'); ?> </title>

</head>

<body>
    <!--wrapper-->
    <div class="wrapper">


        <?php if(auth()->user()->adminLayout() == 'vertical'): ?>
        <!--sidebar wrapper -->
        <?php echo $__env->make('layouts.syndron.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!--end sidebar wrapper -->

        <!--start header -->
        <?php echo $__env->make('layouts.syndron.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!--end header -->

        <?php elseif(auth()->user()->adminLayout() == 'horizontal'): ?>

        <?php echo $__env->make('layouts.syndron.horizontal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php endif; ?>




        <!--start page wrapper -->
        <div class="page-wrapper">
            <div class="page-content">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
        <!--end page wrapper -->

        <!--start overlay-->
        <div class="overlay toggle-icon"></div>
        <!--end overlay-->

        <!--Start Back To Top Button-->
        <a href="javaScript:;" class="back-to-top"><i class="bx bxs-up-arrow-alt"></i></a>
        <!--End Back To Top Button-->

        <?php echo $__env->make('layouts.syndron.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    <!--end wrapper-->

    <!-- search modal -->
    <div class="modal" id="SearchModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl modal-fullscreen-md-down">
            <div class="modal-content">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.global-search', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-322795952-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>
    </div>
    <!-- end search modal -->

    <!--start switcher-->
    <div class="switcher-wrapper">

        <div class="switcher-body">
            <div class="d-flex align-items-center">
                <h5 class="mb-0 text-uppercase"><?php echo e(__('Theme Customizer')); ?></h5>
                <button type="button" class="btn-close ms-auto close-switcher" aria-label="Close"></button>
            </div>
            <hr />
            <h6 class="fw-bold mb-0"><?php echo e(__('Theme Styles')); ?></h6>
            <hr />
            <div class="d-flex align-items-center justify-content-between">
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="lightmode" checked />
                    <label class="form-check-label" for="lightmode"><?php echo e(__('Light')); ?></label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="darkmode" />
                    <label class="form-check-label" for="darkmode"><?php echo e(__('Dark')); ?></label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="semidark" />
                    <label class="form-check-label" for="semidark"><?php echo e(__('Semi Dark')); ?></label>
                </div>
            </div>
            <hr />
            <div class="form-check">
                <input class="form-check-input" type="radio" id="minimaltheme" name="flexRadioDefault" />
                <label class="form-check-label" for="minimaltheme"><?php echo e(__('Minimal Theme')); ?></label>
            </div>
            <hr />
            <h6 class="fw-bold mb-0"><?php echo e(__('Header Style')); ?></h6>
            <hr />
            <form action="<?php echo e(route('admin.update.admin-layout')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="d-flex align-items-center justify-content-between">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="admin_layout" id="Horizontal" value="horizontal" />
                        <label class="form-check-label" for="Horizontal"><?php echo e(__('Horizontal')); ?></label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="admin_layout" id="Vertical" value="vertical" />
                        <label class="form-check-label" for="Vertical"><?php echo e(__('Vertical')); ?></label>
                    </div>
                </div>
                <div class="d-flex justify-content-end mt-3">
                    <button class="btn btn-sm btn-primary" type="submit" ">
                        <?php echo e(__('Save Changes')); ?>

                    </button>
                </div>
            </form>
            <hr />
            <h6 class="fw-bold mb-0"><?php echo e(__('Header Colors')); ?></h6>
            <hr />
            <div class="header-colors-indigators">
                <div class="row row-cols-auto g-3">
                    <div class="col">
                        <div class="indigator headercolor1" id="headercolor1"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor2" id="headercolor2"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor3" id="headercolor3"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor4" id="headercolor4"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor5" id="headercolor5"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor6" id="headercolor6"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor7" id="headercolor7"></div>
                    </div>
                    <div class="col">
                        <div class="indigator headercolor8" id="headercolor8"></div>
                    </div>
                </div>
            </div>
            <hr />
            <h6 class="fw-bold mb-0"><?php echo e(__('Sidebar Colors')); ?></h6>
            <hr />
            <div class="header-colors-indigators">
                <div class="row row-cols-auto g-3">
                    <div class="col">
                        <div class="indigator sidebarcolor1" id="sidebarcolor1"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor2" id="sidebarcolor2"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor3" id="sidebarcolor3"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor4" id="sidebarcolor4"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor5" id="sidebarcolor5"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor6" id="sidebarcolor6"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor7" id="sidebarcolor7"></div>
                    </div>
                    <div class="col">
                        <div class="indigator sidebarcolor8" id="sidebarcolor8"></div>
                    </div>
                </div>
            </div>
            <hr>
            <button id="clearThemeSettings" class="btn btn-danger"><?php echo e(__('Clear Theme Settings')); ?></button>

        </div>
    </div>
    <!--end switcher-->


    <!-- Bootstrap JS -->
    <script src="/assets/themes/syndron/js/bootstrap.bundle.min.js"></script>
    <!--plugins-->
    <script src="/assets/themes/syndron/js/jquery.min.js"></script>
    <script src="/assets/themes/syndron/plugins/simplebar/js/simplebar.min.js"></script>
    <script src="/assets/themes/syndron/plugins/metismenu/js/metisMenu.min.js"></script>
    <script src="/assets/themes/syndron/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
    <script src="/assets/themes/syndron/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
    <script src="/assets/themes/syndron/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="/assets/themes/syndron/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://unpkg.com/persian-date@latest/dist/persian-date.min.js"></script>
    <script src="https://unpkg.com/persian-datepicker@latest/dist/js/persian-datepicker.min.js"></script>

    <!--app JS-->
    <script src="/assets/themes/syndron/js/app.js"></script>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scriptConfig(); ?>


    <?php echo $__env->yieldContent('script'); ?>

    <?php if(session('sweetalert')): ?>
    <?php if (isset($component)) { $__componentOriginalfdf978c6370ba21228b39187c8e063de = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfdf978c6370ba21228b39187c8e063de = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.sweetalert2','data' => ['json' => session("sweetalert")]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('sweetalert2'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['json' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session("sweetalert"))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfdf978c6370ba21228b39187c8e063de)): ?>
<?php $attributes = $__attributesOriginalfdf978c6370ba21228b39187c8e063de; ?>
<?php unset($__attributesOriginalfdf978c6370ba21228b39187c8e063de); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfdf978c6370ba21228b39187c8e063de)): ?>
<?php $component = $__componentOriginalfdf978c6370ba21228b39187c8e063de; ?>
<?php unset($__componentOriginalfdf978c6370ba21228b39187c8e063de); ?>
<?php endif; ?>
    <?php endif; ?>
    <script>
        // document.addEventListener('DOMContentLoaded', function() {
        //     $(document).ready(function() {
        //         tinymce.init({
        //             selector: 'textarea#.tiny-mce',
        //             plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount fullscreen preview',
        //             toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        //             language: 'fa',
        //         });
        //     });
        // });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/layouts/syndron/app.blade.php ENDPATH**/ ?>