<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-sm-4">
        <div class="card radius-15">
            <div class="card-body text-center">
                <div class="p-4 border radius-15">
                    <img src="<?php echo e($user->profile_image ?? '/assets/themes/blesser/images/user.png'); ?>" width="110" height="110" class="rounded-circle shadow" alt="">
                    <h5 class="mb-0 mt-5"><?php echo e($user->name); ?></h5>
                    <p class="mb-3"><?php echo e($user->email); ?></p>

                </div>
            </div>
        </div>
        <div class="card radius-15">
            <div class="card-body text-center">
                <div class="p-1  radius-15 d-flex justify-content-right align-items-center flex-wrap">
                    <a href="<?= route('admin.settings.users.edit', $user->id) ?>" class="btn btn-outline-primary m-1"><i class="bx bx-edit-alt"></i><?php echo e(__('edit user ')); ?></a>
                    <a href="<?= route('admin.settings.user.role.assign', $user->id) ?>" class="btn btn-outline-primary m-1"><i class="bx bx-lock-alt"></i><?php echo e(__('role assignment')); ?></a>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-8">
        <section id="user-info">
            <!-- general info -->
            <div class="card radius-15">
                <div class="card-header">
                    <p class="header-title p-0 m-0"><?php echo e(__('user information')); ?></p>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <?php echo e(__('name')); ?>:
                            <?php echo e((isset($user->name)) ? $user->name : __('not defined')); ?>

                        </div>
                        <div class="col-sm-6">
                            <?php echo e(__('username')); ?>:
                            <?php echo e((isset($user->username)) ? $user->username : __('not defined')); ?>

                        </div>
                        <div class="col-sm-6">
                            <?php echo e(__('Social Number (ID Num)')); ?>:
                            <?php echo e((isset($user->social_number)) ? $user->social_number : __('not defined')); ?>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 mb-3">
                            <?php echo e(__('phone number ')); ?>:
                            <?php echo e((isset($user->phone))?$user->phone : __('not defined')); ?>

                        </div>
                        <div class="col-sm-12 mb-3">
                            <?php echo e(__('address')); ?>:
                            <?php echo e((isset($user->email))?$user->email : __('not defined')); ?>

                        </div>
                    </div>
                    <div class="d-flex justify-content-center">
                        <div type="button" class="btn btn-primary m-3"><?php echo e(__('wallet')); ?><span class="badge bg-dark"> <?php echo e($user->wallet->balance ?? 0); ?> </span></div>
                    </div>
                </div>
            </div>


            <!-- user ability -->
            <div class="card radius-15">
                <div class="card-header">
                    <p class="header-title p-0 m-0"><?php echo e(__('user ability')); ?></p>
                </div>
                <div class="card-body">
                    <p><?php echo e(__('User\'s roles')); ?></p>
                    <div class="d-flex flex-wrap mb-3">
                        <?php $__currentLoopData = $user->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="badge bg-dark m-2"><?php echo e($role); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <p><?php echo e(__('User\'s permissions')); ?></p>
                    <div class="d-flex flex-wrap mb-3">
                        <?php $__currentLoopData = $user->getAllPermissions('name')->pluck('name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="badge bg-dark m-1"><?php echo e($permissions); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <!-- user validation -->
            <div class="card radius-15">
                <div class="card-header">
                    <p class="header-title p-0 m-0"><?php echo e(__('user validation ')); ?></p>
                </div>
                <div class="card-body">
                    <div>
                        <?php if($user->email_verified_at != null): ?>
                        <p>
                            <i class="fadeIn animated bx bx-check text-success"></i>
                            <?php echo e(__('user email has been verified')); ?>

                        </p>
                        <?php else: ?>
                        <p>
                            <i class="fadeIn animated bx bx-x text-danger"></i>
                            <?php echo e(__('user email has not been verified')); ?>

                        </p>
                        <?php endif; ?>
                    </div>
                    <div>
                        <?php if($user->phone_verified_at != null): ?>
                        <p>
                            <i class="fadeIn animated bx bx-check text-success"></i>
                            <?php echo e(__('user phone number has been verified')); ?>

                        </p>
                        <?php else: ?>
                        <p>
                            <i class="fadeIn animated bx bx-x text-danger"></i>
                            <?php echo e(__('user phone number has not been verified')); ?>

                        </p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>


        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.syndron.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/settings/users/show.blade.php ENDPATH**/ ?>