<?php $__env->startSection('content'); ?>
<div class="container pb-28 pt-6 lg:pb-10">
    <!--  Breadcrumb -->
    <div class="mb-2 rounded-lg bg-muted shadow lg:mb-6">
        <ol class="relative grid grid-cols-3 overflow-hidden rounded-lg">
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-shopping-cart h-6 w-6 md:h-8 md:w-8"></div>
                <p class="leading-none">سبد خرید</p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary/50 sm:text-sm md:text-base">
                <div class="i-lucide-clipboard-pen-line h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none">شیوه ارسال</p>
            </li>
            <li class="z-10 flex flex-col items-center justify-center gap-2 p-4 text-xs text-primary sm:text-sm md:text-base">
                <div class="i-lucide-credit-card h-6 w-6 md:h-8 md:w-8"></div>

                <p class="leading-none">پرداخت</p>
            </li>
            <!--  for position set value 0 , 33.33% , 66.66%  -->
            <div class="absolute bottom-0 z-0 h-full w-1/3 touch-none bg-primary/10 transition-all duration-300" style="inset-inline-start: 66.66%"></div>
        </ol>
    </div>
    <!-- Content -->
    <div class="relative mx-auto max-w-[450px] overflow-hidden rounded-lg bg-muted p-3 shadow md:p-6">
        <div class="relative h-10 w-full">
            <div class="absolute -top-24 h-full w-full">
                <div class="relative flex h-full w-full items-center justify-center [--baseOpacity:1] [--baseSize:80px] [--duration:1.5s] [--opacityStep:0.05] [--scale:1.2] [--sizeStep:64px]">
                    <div class="border- ripple absolute rounded-full bg-primary/30 [--i:0]"></div>
                    <div class="border- ripple absolute rounded-full bg-primary/30 [--i:1]"></div>
                    <div class="border- ripple absolute rounded-full bg-primary/30 [--i:2]"></div>
                    <div class="border- ripple absolute rounded-full bg-primary/30 [--i:3]"></div>
                </div>
            </div>
        </div>

        <div class="relative">
            <h1 class="mb-8 text-center text-lg lg:text-xl">
                پرداخت
                <?php if($payment->status == 'successful'): ?>
                <h3 class="text-center text-green-600">
                    وضعیت: پرداخت شده
                </h3>
                <?php else: ?>
                <h3 class="text-center text-red-600">
                    وضعیت: پرداخت نشده
                </h3>
                <?php endif; ?>
            </h1>
            <div class="mb-6">



                <div class="flex items-center justify-between gap-x-2 py-6">
                    <div class="text-sm text-text/95 lg:text-base">
                        <?php echo e(__('UUID')); ?>

                    </div>
                    <div class="flex items-center gap-1 text-sm font-medium text-primary lg:text-base">
                        <div class="font-bold"> <?php echo e($payment->uuid); ?> </div>
                        <div class="text-xs lg:text-sm">
                        </div>
                    </div>
                </div>
                <div class="flex items-center justify-between gap-x-2 py-6">
                    <div class="text-sm text-text/95 lg:text-base">
                        <?php echo e(__('amount')); ?>

                    </div>
                    <div class="flex items-center gap-1 text-sm font-medium text-primary lg:text-base">
                        <div class="font-bold">
                            <?php echo e(number_format($payment->amount)); ?>

                            <?php echo e(getCurrency()); ?>

                        </div>
                        <div class="text-xs lg:text-sm">
                        </div>
                    </div>
                </div>
            </div>
            <div class="space-y-4">
                <!-- <p class="text-center text-xs text-text/80 sm:text-sm">
                    <?php echo e(__('It is not possible to edit the shopping cart after confirmation.')); ?>

                </p> -->

                <?php if($payment->status == 'successful'): ?>
                <?php if($is_mobile): ?>
                <a class="block btn-primary w-full py-2.5" href="intent://123#Intent;scheme=shop;package=com.karaertebat.shop;end">
                    بازگشت به برنامه
                </a>
                <?php else: ?>
                <a class="block btn-primary w-full py-2.5" href="<?php echo e(route('user.dashboard')); ?>">
                    بازگشت به برنامه
                </a>
                <?php endif; ?>
                <?php else: ?>
                <a class="block btn-primary w-full py-2.5" href="<?php echo e(route('payment.pay',['uuid' => $payment->uuid])); ?>">
                    پرداخت
                </a>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.blesser.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/payment.blade.php ENDPATH**/ ?>