<?php if($products->isNotEmpty()): ?>
<section class="container py-10">
    <div class="rounded-lg border bg-muted px-5 shadow lg:px-3">
        <!-- Title -->
        <div class="mb-8 mt-6 flex items-center justify-center gap-2 font-medium lg:text-lg xl:text-xl">
            <div class="i-hugeicons-coupon-percent size-7 stroke-2 text-warning"></div>
            <div><?php echo e($title); ?></div>
        </div>

        <div class="grid grid-cols-2 gap-px bg-secondary lg:grid-cols-6 [&>*]:bg-muted">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e($product['url']); ?>" class="flex grow flex-col justify-between gap-6 px-4 py-3 lg:px-2">
                <img src="<?php echo e($product['image']); ?>" alt="<?php echo e($product['title']); ?>" class="rounded-lg aspect-square object-cover" />

                <p class="line-clamp-2 text-sm 2xl:text-base"><?php echo e($product['title']); ?></p>

                <div class="gap-x-1 text-end font-bold text-primary">
                    <div class="flex h-5 items-center justify-between text-sm text-text/50 xs:text-base">
                        <?php if(!empty($product['off_percent'])): ?>
                        <div class="rounded-full bg-warning px-2 py-px text-sm font-normal text-white">
                            <?php echo e($product['off_percent']); ?>%
                        </div>
                        <?php endif; ?>
                        <?php if(!empty($product['old_price']) && number_format($product['old_price']) != $product['price']): ?>
                        <del><?php echo e(number_format($product['old_price'])); ?></del>
                        <?php endif; ?>
                    </div>

                    <span class="text-sm xs:text-base"><?php echo e($product['price'] == 0 ? 'برای خرید تماس بگیرید' : $product['price']); ?></span>
                    <?php if($product['price'] != 0): ?>
                    <span class="text-sm font-light">
                        <?php echo e(getCurrency()); ?>

                    </span>
                    <?php endif; ?>
                </div>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/components/blesser/element/product-grid.blade.php ENDPATH**/ ?>