<!doctype html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <title><?php echo e(__('Builder')); ?> – <?php echo e($page->title); ?></title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <script>
        
        window.BUILDER_CONFIG = {
            PAGE_ID: <?php echo json_encode($page->id) ?>,
            CSRF: <?php echo json_encode(csrf_token()) ?>,
            URL_LOAD: <?php echo json_encode(url('/admin/grapesjs/assets/pages/' . $page->id)) ?>,
            URL_STORE: <?php echo json_encode(url('/admin/grapesjs/assets/pages/' . $page->id)) ?>,
            URL_UPLOAD: <?php echo json_encode(url('/admin/grapesjs/assets/assets')) ?>,


            STYLES: [
                '/assets/themes/blesser/css/base.css',
                '/assets/themes/blesser/css/dependencies/swiper.min.css',
                '/assets/themes/blesser/css/fonts.css',
                '/assets/themes/blesser/css/dependencies/nouislider.min.css',
                // or if you’re on Vite, echo the build path:
                <?php echo json_encode(\Illuminate\Support\Facades\Vite::asset('resources/css/app.css')) ?>
            ]
        };
    </script>


    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/admin/grapesjs.js']); ?>

    
    
    <style>
        html,
        body {
            height: 100vh;
            display: grid;
            grid-template-areas:
                " header "
                " main ";

            grid-template-rows: 56px 1fr;

        }

        header {
            grid-area: header;

        }

        main {
            grid-area: main;
        }

        .font-vaz {
            font-family: 'Vazirmatn';
        }

        /* Primary color for the background */
        #gjs .gjs-one-bg {
            background-color: #0f172b;
        }

        /* Secondary color for the text color */
        #gjs .gjs-two-color {
            color: rgba(255, 255, 255, 0.7);
        }

        /* Tertiary color for the background */
        #gjs .gjs-three-bg {
            background-color: #0f172b;
            color: white;
        }

        /* Quaternary color for the text color */
        #gjs .gjs-four-color,
        #gjs .gjs-four-color-h:hover {
            color: #003265;
        }

        /* under topbar */
    </style>
</head>

<body class="bg-slate-50 text-slate-900">

    <!-- Topbar -->
    <header class="  bg-slate-900 text-white z-50 shadow-sm">
        <div class="h-full max-w-7xl mx-auto px-3 sm:px-6 flex items-center gap-3">
            <div class="flex items-center gap-2">
                <div class="inline-flex items-center justify-center w-8 h-8 rounded-lg bg-emerald-500/20">
                    <svg viewBox="0 0 24 24" class="w-5 h-5">
                        <path fill="currentColor" d="M4 4h7v7H4zm9 0h7v7h-7zM4 13h7v7H4zm9 7v-7h7v7z" />
                    </svg>
                </div>
                <div class="leading-tight">
                    <div class="font-vaz font-semibold">GrapesJS <?php echo e(__('Editor')); ?></div>
                    <div class="font-vaz text-xs text-slate-300" dir="rtl"><?php echo e(__('Editing')); ?>: <?php echo e($page->title); ?> (<?php echo e(__('slug')); ?>: <?php echo e($page->slug); ?>)</div>
                </div>
            </div>

            <div class="ml-auto flex items-center gap-2">
                <a href="<?php echo e(route('admin.page.index')); ?>" id="btn-pages-list" class="font-vaz cursor-pointer px-3 py-1.5 rounded-lg bg-slate-800 hover:bg-slate-700 text-sm"><?php echo e(__('Pages List')); ?></a>
                <a href="<?php echo e(route('page', $page->slug)); ?>" target="_blank" id="btn-view-page" class="font-vaz cursor-pointer px-3 py-1.5 rounded-lg bg-slate-800 hover:bg-slate-700 text-sm"><?php echo e(__('View Page')); ?></a>

                <div class="mx-1  " style=""> | </div>
                <button id="btn-undo" class="font-vaz cursor-pointer px-3 py-1.5 rounded-lg bg-slate-800 hover:bg-slate-700 text-sm"><?php echo e(__('Undo')); ?></button>
                <button id="btn-redo" class="font-vaz cursor-pointer px-3 py-1.5 rounded-lg bg-slate-800 hover:bg-slate-700 text-sm"><?php echo e(__('Redo')); ?></button>
                <button id="btn-clear" class="font-vaz cursor-pointer px-3 py-1.5 rounded-lg bg-slate-800 hover:bg-slate-700 text-sm"><?php echo e(__('Clear')); ?></button>

                <button id="btn-clear" class="font-vaz cursor-pointer px-3 py-1.5 rounded-lg bg-slate-800 hover:bg-slate-700 text-sm" onclick="window.__editor__.store();"><?php echo e(__('Save')); ?></button>

                <form id="publish-form" action="<?php echo e(url('/admin/pages/'.$page->id.'/publish')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit"
                        class="font-vaz cursor-pointer px-4 py-1.5 rounded-lg bg-emerald-600 hover:bg-emerald-500 text-sm font-semibold">
                        <?php echo e(__('Publish')); ?>

                    </button>
                </form>
            </div>

        </div>
    </header>

    <main>
        <div id="gjs"></div>
    </main>

    <!-- Runtime config for the JS bundle -->


    <!-- Tiny helpers bound in grapesjs.js (so they exist after init) -->
    <script>
        document.getElementById('btn-clear')?.addEventListener('click', () => {
            if (!window.__editor__) return;
            if (confirm('This will clear the canvas. Continue?')) {
                window.__editor__.DomComponents.clear();
                window.__editor__.CssComposer.clear();
            }
        });
        document.getElementById('btn-undo')?.addEventListener('click', () => window.__editor__?.UndoManager.undo());
        document.getElementById('btn-redo')?.addEventListener('click', () => window.__editor__?.UndoManager.redo());
    </script>
</body>

</html>
<?php /**PATH D:\_projects\Laravel\e-commerce-v2\resources\views/pages/admin/page/grapesjs/builder.blade.php ENDPATH**/ ?>