<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Schema::create(prefixedTable('votes'), function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->morphs('votable');
            $table->enum('vote_type', ['up', 'down']);
            $table->timestamps();
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists(prefixedTable('votes'));
    }
};
