<?php

namespace Artemis\Faq\Http\Requests;

use Auth;
use Illuminate\Foundation\Http\FormRequest;

class QuestionUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check();
    }
    
    public function rules(): array
    {
        return [
            'slug' => ['sometimes', 'string', 'min:3', 'max:255', 'unique:questions,slug'],
            'title' => ['sometimes', 'string', 'min:3', 'max:255'],
            'body' => ['sometimes', 'string', 'min:3', 'max:1000'],
            'category_id' => ['nullable', 'integer', 'exists:categories,id'],
        ];
    }
}
