
## ✅ Phase 1: Test Strategy and Approach

### 🎯 **Main Goal**

Ensure that all components of the loyalty system (tiers, rewards, referrals, points, redemptions, and settings) work **individually** and **as a system** under common use cases and edge cases.

---

## ✅ Phase 2: Testing Layers & Approach

| Layer                 | Description                                                           | Type               |
| --------------------- | --------------------------------------------------------------------- | ------------------ |
| **Unit tests**        | Test isolated model logic and traits (no DB involved, mock if needed) | `phpunit`          |
| **Feature tests**     | Test HTTP routes, controllers, middleware, views, DB states, etc.     | `php artisan test` |
| **Integration tests** | Test cross-module workflows: referrals + rewards + redemption         | `php artisan test` |

> All tests go under: `tests/Feature/Loyalty` and `tests/Unit/Loyalty`

---

## ✅ Phase 3: Key Scenarios to Test

### 🔹 Tiers

* Assign correct tier based on point boundaries
* Upgrade tier when points increase
* Edge: user between two tiers, or exceeds max

### 🔹 Rewards

* Can list and view rewards
* Cannot redeem if not enough points
* Successful reward redemption subtracts points

### 🔹 Referrals

* User can refer another
* Referral gives bonus to referrer and/or referee
* Cannot refer self or duplicate referral

### 🔹 Loyalty Points

* User can earn points from multiple sources
* Total balance reflects earned - redeemed
* History log is accurate and ordered

### 🔹 Settings

* Admin can toggle settings like "referral\_bonus"
* Settings update is respected during point award

### 🔹 UI/Access

* Only admins can access admin panel
* Authenticated users see their loyalty data
* Unauthorized access returns 403 or redirects

---

## ✅ Phase 4: Test Folder Structure (Proposal)

```
tests/
├── Feature/
│   └── Loyalty/
│       ├── TierTest.php
│       ├── RewardRedemptionTest.php
│       ├── ReferralSystemTest.php
│       ├── PointEarningTest.php
│       ├── LoyaltySettingsTest.php
│       ├── AdminAccessTest.php
│       └── ClientAccessTest.php
├── Unit/
│   └── Loyalty/
│       ├── TierTraitTest.php
│       ├── ReferralTraitTest.php
│       ├── PointBalanceCalculationTest.php
│       └── RedemptionValidationTest.php
```

---

## ✅ Phase 5: Test List Summary

| Test File                     | Key Assertions                                                 |
| ----------------------------- | -------------------------------------------------------------- |
| `TierTest`                    | Correct tier assigned, upgrades work, boundaries respected     |
| `RewardRedemptionTest`        | Redemption logic, insufficient points error, point subtraction |
| `ReferralSystemTest`          | Referrer/referee logic, bonuses assigned, errors for self      |
| `PointEarningTest`            | Earn points, view history, total balance updated               |
| `LoyaltySettingsTest`         | Settings update, toggle features, default values               |
| `AdminAccessTest`             | Admin routes are protected, visible only to admins             |
| `ClientAccessTest`            | Users can view points, rewards, and redeem correctly           |
| `TierTraitTest`               | `currentTier()` returns correct model, upgrade logic           |
| `ReferralTraitTest`           | `referredBy()` and `referralsMade()` behave properly           |
| `PointBalanceCalculationTest` | Point sum calculations from transactions                       |
| `RedemptionValidationTest`    | Reward model validation rules work as expected                 |

---

