<?php

namespace Artemis\Loyalty\Console\Commands;

use Illuminate\Console\Command;

class LoyaltyTablesCommand extends Command
{
    protected $signature = 'loyalty:tables {--migrate}';
    protected $description = 'Publish Loyalty migrations (and optionally run migrate)';

    public function handle()
    {
        $this->info(__('Publishing Loyalty migrations...'));

        $this->callSilent('vendor:publish', [
            '--tag' => 'loyalty-migrations',
            '--force' => true
        ]);

        $this->info(__('Loyalty migrations published to database/migrations'));

        if ($this->option('migrate')) {
            $this->info(__('Running migrations...'));
            $this->call('migrate');
        } else {
            $this->warn(__('Migrations were not run. Use --migrate to run them automatically.'));
        }

        return 0;
    }
}
